/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import io.gitlab.arturbosch.detekt.rules.bugs.EqualsAlwaysReturnsTrueOrFalse$isSingleReturnWithBooleanConstant$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsAlwaysReturnsTrueOrFalse;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "returnsBooleanConstant", "", "isSingleReturnWithBooleanConstant", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isBooleanConstant", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nEqualsAlwaysReturnsTrueOrFalse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EqualsAlwaysReturnsTrueOrFalse.kt\nio/gitlab/arturbosch/detekt/rules/bugs/EqualsAlwaysReturnsTrueOrFalse\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n310#2,14:91\n229#2,2:105\n241#2:107\n328#2:108\n309#2,15:109\n229#2,2:124\n241#2:126\n328#2:127\n1734#3,3:128\n*S KotlinDebug\n*F\n+ 1 EqualsAlwaysReturnsTrueOrFalse.kt\nio/gitlab/arturbosch/detekt/rules/bugs/EqualsAlwaysReturnsTrueOrFalse\n*L\n75#1:91,14\n75#1:105,2\n75#1:107\n75#1:108\n79#1:109,15\n79#1:124,2\n79#1:126\n79#1:127\n84#1:128,3\n*E\n"})
public final class EqualsAlwaysReturnsTrueOrFalse
extends Rule {
    @NotNull
    private final Issue issue;

    public EqualsAlwaysReturnsTrueOrFalse(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("EqualsAlwaysReturnsTrueOrFalse", Severity.Defect, "Having an `equals()` method that always returns true or false is not a good idea. It does not follow the contract of this method. Consider a good default implementation (e.g. `this == other`).", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ EqualsAlwaysReturnsTrueOrFalse(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (MethodSignatureKt.isEqualsFunction(function2) && this.returnsBooleanConstant(function2)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(function2), "This equals function always returns the same result regardless of the input parameters.", null, null, 24, null));
        }
    }

    private final boolean returnsBooleanConstant(KtNamedFunction $this$returnsBooleanConstant) {
        KtExpression ktExpression = $this$returnsBooleanConstant.getBodyExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression bodyExpression = ktExpression;
        return bodyExpression instanceof KtConstantExpression ? this.isBooleanConstant(bodyExpression) : this.isSingleReturnWithBooleanConstant(bodyExpression);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSingleReturnWithBooleanConstant(KtExpression bodyExpression) {
        KtExpression ktExpression;
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$forEachDescendantOfType$iv$iv$iv$iv2;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv2;
        void $this$collectDescendantsOfType$iv;
        PsiElement psiElement = bodyExpression;
        Function1<KtReturnExpression, Boolean> predicate$iv = arg_0 -> EqualsAlwaysReturnsTrueOrFalse.isSingleReturnWithBooleanConstant$lambda$0(bodyExpression, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        Iterator iterator2 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo22 = false;
        void var11_15 = $this$collectDescendantsOfTypeTo$iv$iv$iv2;
        Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType22 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv2);
        $this$forEachDescendantOfType$iv$iv$iv$iv2.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke(element);
                }
            }
        });
        List returnExpressionsInBlock = (List)to$iv$iv$iv;
        KtReturnExpression ktReturnExpression = (KtReturnExpression)CollectionsKt.firstOrNull(returnExpressionsInBlock);
        KtExpression lastValidReturnExpression = ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null;
        PsiElement $this$collectDescendantsOfType_u24default$iv = bodyExpression;
        Function1 predicate$iv2 = isSingleReturnWithBooleanConstant$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        $i$f$collectDescendantsOfType2 = false;
        PsiElement $this$collectDescendantsOfType$iv$iv2 = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType3 = false;
        PsiElement $i$f$collectDescendantsOfTypeTo22 = $this$collectDescendantsOfType$iv$iv2;
        Collection to$iv$iv$iv2 = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void $i$f$forEachDescendantOfType22 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv2 = new Function1<KtReturnExpression, Unit>(predicate$iv2, to$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv2){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke(element);
                }
            }
        });
        List allReturnExpressions = (List)to$iv$iv$iv2;
        boolean hasNoNestedReturnExpression = allReturnExpressions.size() == returnExpressionsInBlock.size();
        KtExpression ktExpression2 = lastValidReturnExpression;
        if (ktExpression2 == null) return false;
        if (!this.isBooleanConstant(ktExpression2)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (hasNoNestedReturnExpression) return true;
        Iterable $this$all$iv = allReturnExpressions;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl2 = false;
            ktExpression = it.getReturnedExpression();
        } while (Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, lastValidReturnExpression.getText()));
        return false;
    }

    private final boolean isBooleanConstant(PsiElement $this$isBooleanConstant) {
        return Intrinsics.areEqual($this$isBooleanConstant.getNode().getElementType(), KtNodeTypes.BOOLEAN_CONSTANT);
    }

    private static final boolean isSingleReturnWithBooleanConstant$lambda$0(KtExpression $bodyExpression, KtReturnExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getParent(), $bodyExpression) || it.getParent() instanceof KtAnnotatedExpression && Intrinsics.areEqual(it.getParent().getParent(), $bodyExpression);
    }

    public EqualsAlwaysReturnsTrueOrFalse() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

