/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ElseCaseInsteadOfExhaustiveWhen;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignoredSubjectTypes", "", "", "getIgnoredSubjectTypes$annotations", "()V", "getIgnoredSubjectTypes", "()Ljava/util/List;", "ignoredSubjectTypes$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitWhenExpression", "", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "checkForElseCaseInsteadOfExhaustiveWhenExpression", "isNonExpectedSealedClass", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-errorprone"})
public final class ElseCaseInsteadOfExhaustiveWhen
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoredSubjectTypes$delegate;

    public ElseCaseInsteadOfExhaustiveWhen(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("ElseCaseInsteadOfExhaustiveWhen", Severity.Warning, "A `when` expression that has an exhaustive set of cases should not contain an `else` case.", Debt.Companion.getFIVE_MINS());
        this.ignoredSubjectTypes$delegate = ConfigPropertyKt.config(CollectionsKt.emptyList());
    }

    public /* synthetic */ ElseCaseInsteadOfExhaustiveWhen(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getIgnoredSubjectTypes() {
        return (List)this.ignoredSubjectTypes$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="List of fully qualified types which should be ignored for when expressions with a subject. Example `kotlinx.serialization.json.JsonObject`")
    private static /* synthetic */ void getIgnoredSubjectTypes$annotations() {
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression whenExpression) {
        Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
        super.visitWhenExpression(whenExpression);
        this.checkForElseCaseInsteadOfExhaustiveWhenExpression(whenExpression);
    }

    private final void checkForElseCaseInsteadOfExhaustiveWhenExpression(KtWhenExpression whenExpression) {
        block7: {
            boolean isSealedSubject;
            boolean isEnumSubject;
            block6: {
                boolean isBooleanSubject;
                Object object;
                KtExpression ktExpression = whenExpression.getSubjectExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression subjectExpression = ktExpression;
                if (whenExpression.getElseExpression() == null) {
                    return;
                }
                KotlinType subjectType = CallUtilKt.getType(subjectExpression, this.getBindingContext());
                if (CollectionsKt.contains((Iterable)this.getIgnoredSubjectTypes(), (object = subjectType) != null && (object = TypeUtilsKt.fqNameOrNull((KotlinType)object)) != null ? ((FqName)object).toString() : null)) {
                    return;
                }
                isEnumSubject = WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType) != null;
                isSealedSubject = this.isNonExpectedSealedClass(subjectType);
                KotlinType kotlinType = subjectType;
                boolean bl = kotlinType != null ? org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.isBooleanOrNullableBoolean(kotlinType) : (isBooleanSubject = false);
                if (isEnumSubject || isSealedSubject) break block6;
                if (!isBooleanSubject) break block7;
            }
            String subjectTypeName = isEnumSubject ? "enum class" : (isSealedSubject ? "sealed class" : "boolean");
            String message = "When expression with " + subjectTypeName + " subject should not contain an `else` case.";
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, whenExpression, 0, 2, null), message, null, null, 24, null));
        }
    }

    private final boolean isNonExpectedSealedClass(KotlinType type2) {
        ClassDescriptor sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed(type2);
        return sealedClassDescriptor != null && !sealedClassDescriptor.isExpect();
    }

    public ElseCaseInsteadOfExhaustiveWhen() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ElseCaseInsteadOfExhaustiveWhen.class, "ignoredSubjectTypes", "getIgnoredSubjectTypes()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

