/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Deprecated(message="Rule deprecated as compiler performs this check by default")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DuplicateCaseInWhenExpression;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nDuplicateCaseInWhenExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateCaseInWhenExpression.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DuplicateCaseInWhenExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1663#2,8:63\n1557#2:71\n1628#2,3:72\n*S KotlinDebug\n*F\n+ 1 DuplicateCaseInWhenExpression.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DuplicateCaseInWhenExpression\n*L\n46#1:63,8\n51#1:71\n51#1:72,3\n*E\n"})
public final class DuplicateCaseInWhenExpression
extends Rule {
    @NotNull
    private final Issue issue;

    public DuplicateCaseInWhenExpression(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("DuplicateCaseInWhenExpression", Severity.Warning, "Duplicated `case` statements in a `when` expression detected. Both cases should be merged.", Debt.Companion.getTEN_MINS());
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        List<KtWhenEntry> list = expression2.getEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
        Iterable $this$distinctBy$iv = list;
        boolean $i$f$distinctBy2 = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtWhenEntry entry = (KtWhenEntry)e$iv;
            boolean bl = false;
            KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
            Intrinsics.checkNotNullExpressionValue(ktWhenConditionArray, "getConditions(...)");
            String key$iv = ArraysKt.joinToString$default(ktWhenConditionArray, null, null, null, 0, null, DuplicateCaseInWhenExpression::visitWhenExpression$lambda$1$lambda$0, 31, null);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctEntries = list$iv;
        if (!Intrinsics.areEqual(distinctEntries, expression2.getEntries())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<KtWhenEntry> list2 = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "getEntries(...)");
            Iterable $i$f$distinctBy2 = CollectionsKt.subtract((Iterable)list2, distinctEntries);
            boolean $i$f$map = false;
            list$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void entry;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
                Intrinsics.checkNotNullExpressionValue(ktWhenConditionArray, "getConditions(...)");
                collection.add(ArraysKt.joinToString$default(ktWhenConditionArray, null, null, null, 0, null, DuplicateCaseInWhenExpression::visitWhenExpression$lambda$3$lambda$2, 31, null));
            }
            List duplicateEntries = (List)destination$iv$iv;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "When expression has multiple case statements for " + CollectionsKt.joinToString$default(duplicateEntries, "; ", null, null, 0, null, null, 62, null) + '.', null, null, 24, null));
        }
    }

    private static final CharSequence visitWhenExpression$lambda$1$lambda$0(KtWhenCondition it) {
        String string2 = it.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return string2;
    }

    private static final CharSequence visitWhenExpression$lambda$3$lambda$2(KtWhenCondition it) {
        String string2 = it.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return string2;
    }
}

