/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR'\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "mutableTypes", "Lorg/jetbrains/kotlin/name/FqName;", "getMutableTypes$annotations", "()V", "getMutableTypes", "mutableTypes$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nDoubleMutabilityForCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleMutabilityForCollection.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1557#2:96\n1628#2,3:97\n*S KotlinDebug\n*F\n+ 1 DoubleMutabilityForCollection.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection\n*L\n62#1:96\n62#1:97,3\n*E\n"})
public final class DoubleMutabilityForCollection
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty mutableTypes$delegate;
    @NotNull
    private static final List<String> defaultMutableTypes;

    public DoubleMutabilityForCollection(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf("DoubleMutability");
        this.issue = new Issue("DoubleMutabilityForCollection", Severity.CodeSmell, "Using var with mutable collections or values leads to double mutability. Consider using val or immutable collection or value types.", Debt.Companion.getFIVE_MINS());
        this.mutableTypes$delegate = ConfigPropertyKt.config(defaultMutableTypes, DoubleMutabilityForCollection::mutableTypes_delegate$lambda$1);
    }

    public /* synthetic */ DoubleMutabilityForCollection(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Set<FqName> getMutableTypes() {
        return (Set)this.mutableTypes$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="Define a list of mutable types to trigger on when defined with `var`.")
    private static /* synthetic */ void getMutableTypes$annotations() {
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        super.visitProperty(property);
        Annotated annotated = (VariableDescriptor)this.getBindingContext().get(BindingContext.VARIABLE, property);
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return;
        }
        Annotated type2 = annotated;
        FqName standardType = TypeUtilsKt.fqNameOrNull((KotlinType)type2);
        if (property.isVar() && CollectionsKt.contains((Iterable)this.getMutableTypes(), standardType)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, property, 0, 2, null), "Variable " + property.getName() + " is declared as `var` with a mutable type " + standardType + ". Consider using `val` or an immutable collection or value type", null, null, 24, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Set mutableTypes_delegate$lambda$1(List types2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(types2, "types");
        Iterable $this$map$iv = types2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName((String)it));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    public DoubleMutabilityForCollection() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DoubleMutabilityForCollection.class, "mutableTypes", "getMutableTypes()Ljava/util/Set;", 0))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"kotlin.collections.MutableList", "kotlin.collections.MutableMap", "kotlin.collections.MutableSet", "java.util.ArrayList", "java.util.LinkedHashSet", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.HashMap"};
        defaultMutableTypes = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection$Companion;", "", "<init>", "()V", "defaultMutableTypes", "", "", "getDefaultMutableTypes", "()Ljava/util/List;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDefaultMutableTypes() {
            return defaultMutableTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

