/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0013\u001a.\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\f0\f\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/Deprecation;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "hasDeprecationCompilerWarnings", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticWithParameters2;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nDeprecation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Deprecation.kt\nio/gitlab/arturbosch/detekt/rules/bugs/Deprecation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n295#2,2:47\n1#3:49\n*S KotlinDebug\n*F\n+ 1 Deprecation.kt\nio/gitlab/arturbosch/detekt/rules/bugs/Deprecation\n*L\n43#1:47,2\n*E\n"})
public final class Deprecation
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> defaultRuleIdAliases;

    public Deprecation(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("Deprecation", Severity.Defect, "Deprecated elements should not be used.", Debt.Companion.getTWENTY_MINS());
        this.defaultRuleIdAliases = SetsKt.setOf("DEPRECATION");
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        DiagnosticWithParameters2<PsiElement, DeclarationDescriptor, String> diagnostic = this.hasDeprecationCompilerWarnings(element);
        if (diagnostic != null) {
            Entity entity = element instanceof KtNamedDeclaration ? Entity.Companion.atName((KtNamedDeclaration)element) : Entity.Companion.from$default(Entity.Companion, element, 0, 2, null);
            this.report(new CodeSmell(this.getIssue(), entity, element.getText() + " is deprecated with message \"" + diagnostic.getB() + '\"', null, null, 24, null));
        }
        super.visitElement(element);
    }

    private final DiagnosticWithParameters2<PsiElement, DeclarationDescriptor, String> hasDeprecationCompilerWarnings(PsiElement element) {
        DiagnosticWithParameters2 diagnosticWithParameters2;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.getBindingContext().getDiagnostics().forElement(element);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getFactory(), Errors.DEPRECATION)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Diagnostic diagnostic = v0;
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            diagnosticWithParameters2 = (DiagnosticWithParameters2)Errors.DEPRECATION.cast((UnboundDiagnostic)it);
        } else {
            diagnosticWithParameters2 = null;
        }
        return diagnosticWithParameters2;
    }
}

