/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/AvoidReferentialEquality;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "forbiddenTypePatterns", "", "Lkotlin/text/Regex;", "getForbiddenTypePatterns$annotations", "()V", "getForbiddenTypePatterns", "()Ljava/util/List;", "forbiddenTypePatterns$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "checkBinaryExpression", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nAvoidReferentialEquality.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvoidReferentialEquality.kt\nio/gitlab/arturbosch/detekt/rules/bugs/AvoidReferentialEquality\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1755#2,3:81\n1557#2:84\n1628#2,3:85\n*S KotlinDebug\n*F\n+ 1 AvoidReferentialEquality.kt\nio/gitlab/arturbosch/detekt/rules/bugs/AvoidReferentialEquality\n*L\n69#1:81,3\n56#1:84\n56#1:85,3\n*E\n"})
public final class AvoidReferentialEquality
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty forbiddenTypePatterns$delegate;

    public AvoidReferentialEquality(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("AvoidReferentialEquality", Severity.Warning, "Avoid using referential equality and prefer to use referential equality checks instead.", Debt.Companion.getFIVE_MINS());
        this.forbiddenTypePatterns$delegate = ConfigPropertyKt.config(CollectionsKt.listOf("kotlin.String"), AvoidReferentialEquality::forbiddenTypePatterns_delegate$lambda$0);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Regex> getForbiddenTypePatterns() {
        return (List)this.forbiddenTypePatterns$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="Specifies those types for which referential equality checks are considered a rule violation. The types are defined by a list of simple glob patterns (supporting `*` and `?` wildcards) that match the fully qualified type name.")
    private static /* synthetic */ void getForbiddenTypePatterns$annotations() {
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitBinaryExpression(expression2);
        this.checkBinaryExpression(expression2);
    }

    private final void checkBinaryExpression(KtBinaryExpression expression2) {
        boolean bl;
        block6: {
            if (!Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EQEQEQ) && !Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EXCLEQEQEQ)) {
                return;
            }
            Object object = expression2.getLeft();
            if (object == null || (object = CallUtilKt.getType((KtExpression)object, this.getBindingContext())) == null || (object = TypeUtilsKt.fqNameOrNull((KotlinType)object)) == null) {
                return;
            }
            Object checkedType = object;
            String string2 = ((FqName)checkedType).asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String fullyQualifiedType = string2;
            Iterable $this$any$iv = this.getForbiddenTypePatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(fullyQualifiedType)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "Checking referential equality may lead to unwanted results.", null, null, 24, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List forbiddenTypePatterns_delegate$lambda$0(List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(it, "it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$forbiddenTypePatterns_delegate$lambda$0$stub_for_inlining = false;
            collection.add(SplitPatternKt.simplePatternToRegex((String)p0));
        }
        return (List)destination$iv$iv;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(AvoidReferentialEquality.class, "forbiddenTypePatterns", "getForbiddenTypePatterns()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

