/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.tooling;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.RuleSetProvider;
import io.gitlab.arturbosch.detekt.core.Analyzer;
import io.gitlab.arturbosch.detekt.core.DetektResult;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.config.validation.ConfigValidationKt;
import io.gitlab.arturbosch.detekt.core.extensions.ReportingKt;
import io.gitlab.arturbosch.detekt.core.reporting.OutputFacade;
import io.gitlab.arturbosch.detekt.core.util.PerformanceMonitor;
import io.gitlab.arturbosch.detekt.core.util.PerformanceMonitorKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J$\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H 0\u0018H\u0002J\b\u0010$\u001a\u00020%H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR7\u0010\n\u001a'\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000bj\u0002`\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R3\u0010\u0013\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u001e\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u000e0\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u000e0\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001b\u00a8\u0006&"}, d2={"Lio/gitlab/arturbosch/detekt/core/tooling/Lifecycle;", "", "baselineConfig", "Lio/gitlab/arturbosch/detekt/api/Config;", "getBaselineConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "getSettings", "()Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "parsingStrategy", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lio/gitlab/arturbosch/detekt/core/tooling/ParsingStrategy;", "getParsingStrategy", "()Lkotlin/jvm/functions/Function1;", "bindingProvider", "files", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingProvider", "processorsProvider", "Lkotlin/Function0;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "getProcessorsProvider", "()Lkotlin/jvm/functions/Function0;", "ruleSetsProvider", "Lio/gitlab/arturbosch/detekt/api/RuleSetProvider;", "getRuleSetsProvider", "measure", "R", "phase", "Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "block", "analyze", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "detekt-core"})
public interface Lifecycle {
    @NotNull
    public Config getBaselineConfig();

    @NotNull
    public ProcessingSettings getSettings();

    @NotNull
    public Function1<ProcessingSettings, List<KtFile>> getParsingStrategy();

    @NotNull
    public Function1<List<? extends KtFile>, BindingContext> getBindingProvider();

    @NotNull
    public Function0<List<FileProcessListener>> getProcessorsProvider();

    @NotNull
    public Function0<List<RuleSetProvider>> getRuleSetsProvider();

    @NotNull
    public Detektion analyze();

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lifecycle.kt\nio/gitlab/arturbosch/detekt/core/tooling/Lifecycle$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1863#2,2:73\n1863#2,2:75\n*S KotlinDebug\n*F\n+ 1 Lifecycle.kt\nio/gitlab/arturbosch/detekt/core/tooling/Lifecycle$DefaultImpls\n*L\n46#1:73,2\n49#1:75,2\n*E\n"})
    public static final class DefaultImpls {
        private static <R> R measure(Lifecycle $this, PerformanceMonitor.Phase phase, Function0<? extends R> block) {
            return PerformanceMonitorKt.getOrCreateMonitor($this.getSettings()).measure(phase, block);
        }

        @NotNull
        public static Detektion analyze(@NotNull Lifecycle $this) {
            DefaultImpls.measure($this, PerformanceMonitor.Phase.ValidateConfig, () -> DefaultImpls.analyze$lambda$0($this));
            List filesToAnalyze = DefaultImpls.measure($this, PerformanceMonitor.Phase.Parsing, () -> DefaultImpls.analyze$lambda$1($this));
            BindingContext bindingContext = DefaultImpls.measure($this, PerformanceMonitor.Phase.Binding, () -> DefaultImpls.analyze$lambda$2($this, filesToAnalyze));
            Pair pair = DefaultImpls.measure($this, PerformanceMonitor.Phase.LoadingExtensions, () -> DefaultImpls.analyze$lambda$3($this));
            List processors = (List)pair.component1();
            List ruleSets = (List)pair.component2();
            Detektion result2 = DefaultImpls.measure($this, PerformanceMonitor.Phase.Analyzer, () -> DefaultImpls.analyze$lambda$6($this, ruleSets, processors, filesToAnalyze, bindingContext));
            return DefaultImpls.measure($this, PerformanceMonitor.Phase.Reporting, () -> DefaultImpls.analyze$lambda$7($this, result2));
        }

        private static Unit analyze$lambda$0(Lifecycle this$0) {
            ConfigValidationKt.checkConfiguration(this$0.getSettings(), this$0.getBaselineConfig());
            return Unit.INSTANCE;
        }

        private static List analyze$lambda$1(Lifecycle this$0) {
            return this$0.getParsingStrategy().invoke(this$0.getSettings());
        }

        private static BindingContext analyze$lambda$2(Lifecycle this$0, List $filesToAnalyze) {
            return this$0.getBindingProvider().invoke($filesToAnalyze);
        }

        private static Pair analyze$lambda$3(Lifecycle this$0) {
            return TuplesKt.to(this$0.getProcessorsProvider().invoke(), this$0.getRuleSetsProvider().invoke());
        }

        private static Detektion analyze$lambda$6(Lifecycle this$0, List $ruleSets, List $processors, List $filesToAnalyze, BindingContext $bindingContext) {
            Analyzer analyzer2 = new Analyzer(this$0.getSettings(), $ruleSets, $processors);
            Iterable $this$forEach$iv = $processors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileProcessListener it = (FileProcessListener)element$iv;
                boolean bl = false;
                it.onStart($filesToAnalyze, $bindingContext);
            }
            Map<String, List<Finding>> findings = analyzer2.run($filesToAnalyze, $bindingContext);
            Detektion result2 = new DetektResult((Map<String, ? extends List<? extends Finding>>)MapsKt.toSortedMap(findings));
            Iterable $this$forEach$iv2 = $processors;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                FileProcessListener it = (FileProcessListener)element$iv;
                boolean bl = false;
                it.onFinish($filesToAnalyze, result2, $bindingContext);
            }
            return result2;
        }

        private static Detektion analyze$lambda$7(Lifecycle this$0, Detektion $result) {
            Detektion finalResult = ReportingKt.handleReportingExtensions(this$0.getSettings(), $result);
            new OutputFacade(this$0.getSettings()).run(finalResult);
            return finalResult;
        }
    }
}

