/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.settings;

import io.github.detekt.tooling.api.spec.LoggingSpec;
import io.gitlab.arturbosch.detekt.core.settings.LoggingAware;
import io.gitlab.arturbosch.detekt.core.settings.LoggingAwareKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00060\tj\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/core/settings/LoggingFacade;", "Lio/gitlab/arturbosch/detekt/core/settings/LoggingAware;", "spec", "Lio/github/detekt/tooling/api/spec/LoggingSpec;", "<init>", "(Lio/github/detekt/tooling/api/spec/LoggingSpec;)V", "getSpec", "()Lio/github/detekt/tooling/api/spec/LoggingSpec;", "outputChannel", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "getOutputChannel", "()Ljava/lang/Appendable;", "errorChannel", "getErrorChannel", "info", "", "msg", "", "error", "", "debug", "Lkotlin/Function0;", "detekt-core"})
public final class LoggingFacade
implements LoggingAware {
    @NotNull
    private final LoggingSpec spec;
    @NotNull
    private final Appendable outputChannel;
    @NotNull
    private final Appendable errorChannel;

    public LoggingFacade(@NotNull LoggingSpec spec) {
        Intrinsics.checkNotNullParameter(spec, "spec");
        this.spec = spec;
        this.outputChannel = this.spec.getOutputChannel();
        this.errorChannel = this.spec.getErrorChannel();
    }

    @NotNull
    public final LoggingSpec getSpec() {
        return this.spec;
    }

    @Override
    @NotNull
    public Appendable getOutputChannel() {
        return this.outputChannel;
    }

    @Override
    @NotNull
    public Appendable getErrorChannel() {
        return this.errorChannel;
    }

    @Override
    public void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Appendable appendable = this.getOutputChannel().append(msg);
        Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
        Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
    }

    @Override
    public void error(@NotNull String msg, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(error, "error");
        Appendable appendable = this.getErrorChannel().append(msg);
        Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
        Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
        LoggingAwareKt.printStacktraceRecursively(error, this.getErrorChannel());
    }

    @Override
    public void debug(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.spec.getDebug()) {
            Appendable appendable = this.getOutputChannel().append(msg.invoke());
            Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
            Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
        }
    }
}

