/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.rules;

import io.github.detekt.psi.KtFilesKt;
import io.github.detekt.tooling.api.spec.RulesSpec;
import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.MultiRule;
import io.gitlab.arturbosch.detekt.api.RuleSet;
import io.gitlab.arturbosch.detekt.api.RuleSetProvider;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.rules.RuleSetLocator;
import io.gitlab.arturbosch.detekt.core.rules.RuleSetsKt;
import io.gitlab.arturbosch.detekt.core.rules.SingleRuleProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a(\u0010\f\u001a\u0016\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\b\u0012\u00060\u000ej\u0002`\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007*\u00020\u0015\u00a8\u0006\u0016"}, d2={"isActive", "", "Lio/gitlab/arturbosch/detekt/api/Config;", "shouldAnalyzeFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitFile", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "Lio/gitlab/arturbosch/detekt/api/RuleSet;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "associateRuleIdsToRuleSetIds", "", "", "Lio/gitlab/arturbosch/detekt/api/RuleId;", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "ruleSets", "Lkotlin/sequences/Sequence;", "createRuleProviders", "Lio/gitlab/arturbosch/detekt/api/RuleSetProvider;", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nRuleSets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleSets.kt\nio/gitlab/arturbosch/detekt/core/rules/RuleSetsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1368#2:65\n1454#2,5:66\n1#3:71\n*S KotlinDebug\n*F\n+ 1 RuleSets.kt\nio/gitlab/arturbosch/detekt/core/rules/RuleSetsKt\n*L\n30#1:65\n30#1:66,5\n*E\n"})
public final class RuleSetsKt {
    public static final boolean isActive(@NotNull Config $this$isActive) {
        Intrinsics.checkNotNullParameter($this$isActive, "<this>");
        return $this$isActive.valueOrDefault("active", true);
    }

    public static final boolean shouldAnalyzeFile(@NotNull Config $this$shouldAnalyzeFile, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter($this$shouldAnalyzeFile, "<this>");
        Intrinsics.checkNotNullParameter(file2, "file");
        PathFilters filters = PathFiltersKt.createPathFilters($this$shouldAnalyzeFile);
        return filters == null || !filters.isIgnored(KtFilesKt.absolutePath(file2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Finding> visitFile(@NotNull RuleSet $this$visitFile, @NotNull KtFile file2, @NotNull BindingContext bindingContext) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$visitFile, "<this>");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Iterable $this$flatMap$iv = $this$visitFile.getRules();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            BaseRule it = (BaseRule)element$iv$iv;
            boolean bl = false;
            BaseRule.visitFile$default(it, file2, bindingContext, null, 4, null);
            Iterable list$iv$iv = it.getFindings();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List visitFile$default(RuleSet ruleSet, KtFile ktFile, BindingContext bindingContext, int n, Object object) {
        if ((n & 2) != 0) {
            bindingContext = BindingContext.EMPTY;
        }
        return RuleSetsKt.visitFile(ruleSet, ktFile, bindingContext);
    }

    @NotNull
    public static final Map<String, String> associateRuleIdsToRuleSetIds(@NotNull Sequence<RuleSet> ruleSets) {
        Intrinsics.checkNotNullParameter(ruleSets, "ruleSets");
        return MapsKt.toMap(SequencesKt.flatMap(ruleSets, RuleSetsKt::associateRuleIdsToRuleSetIds$lambda$3));
    }

    @NotNull
    public static final List<RuleSetProvider> createRuleProviders(@NotNull ProcessingSettings $this$createRuleProviders) {
        List<RuleSetProvider> list;
        Intrinsics.checkNotNullParameter($this$createRuleProviders, "<this>");
        RulesSpec.RunPolicy runPolicy = $this$createRuleProviders.getSpec().getRulesSpec().getRunPolicy();
        if (Intrinsics.areEqual(runPolicy, RulesSpec.RunPolicy.NoRestrictions.INSTANCE)) {
            list = new RuleSetLocator($this$createRuleProviders).load();
        } else if (runPolicy instanceof RulesSpec.RunPolicy.RestrictToSingleRule) {
            Object v1;
            String ruleId;
            String ruleSetId;
            block6: {
                Pair<String, String> pair = ((RulesSpec.RunPolicy.RestrictToSingleRule)runPolicy).getId();
                ruleSetId = pair.component1();
                ruleId = pair.component2();
                Iterable iterable = new RuleSetLocator($this$createRuleProviders).load();
                for (Object t : iterable) {
                    RuleSetProvider it = (RuleSetProvider)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getRuleSetId(), ruleSetId)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            if (v1 == null) {
                boolean bl = false;
                String string2 = "There was no rule set with id '" + ruleSetId + "'.";
                throw new IllegalArgumentException(string2.toString());
            }
            RuleSetProvider realProvider = v1;
            list = CollectionsKt.listOf(new SingleRuleProvider(ruleId, realProvider));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private static final Sequence<String> associateRuleIdsToRuleSetIds$extractIds(BaseRule rule) {
        Sequence<String> sequence2;
        if (rule instanceof MultiRule) {
            sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)((MultiRule)rule).getRules()), associateRuleIdsToRuleSetIds.extractIds.1.INSTANCE);
        } else {
            String[] stringArray = new String[]{rule.getRuleId()};
            sequence2 = SequencesKt.sequenceOf(stringArray);
        }
        return sequence2;
    }

    private static final Pair associateRuleIdsToRuleSetIds$lambda$3$lambda$2$lambda$1(RuleSet $ruleSet, String ruleId) {
        Intrinsics.checkNotNullParameter(ruleId, "ruleId");
        return TuplesKt.to(ruleId, $ruleSet.getId());
    }

    private static final Sequence associateRuleIdsToRuleSetIds$lambda$3$lambda$2(RuleSet $ruleSet, BaseRule rule) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        return SequencesKt.map(RuleSetsKt.associateRuleIdsToRuleSetIds$extractIds(rule), arg_0 -> RuleSetsKt.associateRuleIdsToRuleSetIds$lambda$3$lambda$2$lambda$1($ruleSet, arg_0));
    }

    private static final Sequence associateRuleIdsToRuleSetIds$lambda$3(RuleSet ruleSet) {
        Intrinsics.checkNotNullParameter(ruleSet, "ruleSet");
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)ruleSet.getRules()), arg_0 -> RuleSetsKt.associateRuleIdsToRuleSetIds$lambda$3$lambda$2(ruleSet, arg_0));
    }
}

