/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.reporting;

import io.github.detekt.report.html.HtmlOutputReport;
import io.github.detekt.report.md.MdOutputReport;
import io.github.detekt.report.sarif.SarifOutputReport;
import io.github.detekt.report.txt.TxtOutputReport;
import io.github.detekt.report.xml.XmlOutputReport;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.CorrectableCodeSmell;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.core.reporting.ColorizerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\"\u0010\u0003\u001a\u00020\u00012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0000\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a(\u0010\u0013\u001a\u0018\u0012\b\u0012\u00060\u0001j\u0002`\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012\u001a(\u0010\u0017\u001a\u0018\u0012\b\u0012\u00060\u0001j\u0002`\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0007H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0007H\u0002\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"defaultReportMapping", "", "reportId", "printFindings", "findings", "", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "BUILD", "EXCLUDE_CORRECTABLE", "DETEKT_OUTPUT_REPORT_PATHS_KEY", "DETEKT_OUTPUT_REPORT_BASE_PATH_KEY", "REPORT_MESSAGE_SIZE_LIMIT", "", "messageReplacementRegex", "Lkotlin/text/Regex;", "excludeCorrectable", "", "Lio/gitlab/arturbosch/detekt/api/Config;", "filterEmptyIssues", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "config", "filterAutoCorrectedIssues", "truncatedMessage", "detailed", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nReporting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reporting.kt\nio/gitlab/arturbosch/detekt/core/reporting/ReportingKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,92:1\n216#2:93\n217#2:107\n216#2:122\n217#2:126\n1557#3:94\n1628#3,3:95\n2669#3,7:98\n1863#3,2:105\n2669#3,7:108\n774#3:123\n865#3,2:124\n535#4:115\n520#4,6:116\n*S KotlinDebug\n*F\n+ 1 Reporting.kt\nio/gitlab/arturbosch/detekt/core/reporting/ReportingKt\n*L\n28#1:93\n28#1:107\n68#1:122\n68#1:126\n30#1:94\n30#1:95,3\n31#1:98,7\n34#1:105,2\n40#1:108,7\n69#1:123\n69#1:124,2\n60#1:115\n60#1:116,6\n*E\n"})
public final class ReportingKt {
    @NotNull
    public static final String BUILD = "build";
    @NotNull
    public static final String EXCLUDE_CORRECTABLE = "excludeCorrectable";
    @NotNull
    public static final String DETEKT_OUTPUT_REPORT_PATHS_KEY = "detekt.output.report.paths.key";
    @NotNull
    public static final String DETEKT_OUTPUT_REPORT_BASE_PATH_KEY = "detekt.output.report.base.path";
    private static final int REPORT_MESSAGE_SIZE_LIMIT = 80;
    @NotNull
    private static final Regex messageReplacementRegex = new Regex("\\s+");

    @NotNull
    public static final String defaultReportMapping(@NotNull String reportId) {
        Intrinsics.checkNotNullParameter(reportId, "reportId");
        String string2 = reportId;
        return Intrinsics.areEqual(string2, TxtOutputReport.class.getSimpleName()) ? "txt" : (Intrinsics.areEqual(string2, XmlOutputReport.class.getSimpleName()) ? "xml" : (Intrinsics.areEqual(string2, HtmlOutputReport.class.getSimpleName()) ? "html" : (Intrinsics.areEqual(string2, SarifOutputReport.class.getSimpleName()) ? "sarif" : (Intrinsics.areEqual(string2, MdOutputReport.class.getSimpleName()) ? "md" : reportId))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String printFindings(@NotNull Map<String, ? extends List<? extends Finding>> findings) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(findings, "findings");
        StringBuilder $this$printFindings_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List debtList = new ArrayList();
        Map<String, ? extends List<? extends Finding>> $this$forEach$iv = findings;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<? extends Finding>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Map.Entry<String, ? extends List<? extends Finding>> element$iv;
            Map.Entry<String, ? extends List<? extends Finding>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String key = entry.getKey();
            List<? extends Finding> issues = entry.getValue();
            Iterable iterable = issues;
            boolean $i$f$map = false;
            Iterator iterator3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Finding finding = (Finding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getIssue().getDebt());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void d;
                Debt $i$f$mapTo2 = (Debt)iterator$iv.next();
                Debt acc = (Debt)accumulator$iv;
                boolean bl4 = false;
                accumulator$iv = acc.plus((Debt)d);
            }
            Debt debt = (Debt)accumulator$iv;
            debtList.add(debt);
            $this$printFindings_u24lambda_u245.append(key + " - " + debt + " debt\n");
            Iterable $this$forEach$iv2 = issues;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Finding it = (Finding)element$iv2;
                boolean bl5 = false;
                $this$printFindings_u24lambda_u245.append("\t");
                $this$printFindings_u24lambda_u245.append(ColorizerKt.yellow(ReportingKt.detailed(it)));
                $this$printFindings_u24lambda_u245.append("\n");
            }
        }
        Iterable $this$reduce$iv = debtList;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void d;
            Debt bl2 = (Debt)iterator$iv.next();
            Debt acc = (Debt)accumulator$iv;
            boolean bl6 = false;
            accumulator$iv = acc.plus((Debt)d);
        }
        Debt overallDebt = (Debt)accumulator$iv;
        $this$printFindings_u24lambda_u245.append("\nOverall debt: " + overallDebt + '\n');
        $this$printFindings_u24lambda_u245.toString();
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public static final boolean excludeCorrectable(@NotNull Config $this$excludeCorrectable) {
        Intrinsics.checkNotNullParameter($this$excludeCorrectable, "<this>");
        return $this$excludeCorrectable.subConfig(BUILD).valueOrDefault(EXCLUDE_CORRECTABLE, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<Finding>> filterEmptyIssues(@NotNull Detektion $this$filterEmptyIssues, @NotNull Config config) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterEmptyIssues, "<this>");
        Intrinsics.checkNotNullParameter(config, "config");
        Map<String, List<Finding>> $this$filter$iv = ReportingKt.filterAutoCorrectedIssues($this$filterEmptyIssues, config);
        boolean $i$f$filter = false;
        Map<String, List<Finding>> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            boolean bl2 = !((Collection)it.getValue()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<Finding>> filterAutoCorrectedIssues(@NotNull Detektion $this$filterAutoCorrectedIssues, @NotNull Config config) {
        Intrinsics.checkNotNullParameter($this$filterAutoCorrectedIssues, "<this>");
        Intrinsics.checkNotNullParameter(config, "config");
        if (!ReportingKt.excludeCorrectable(config)) {
            return $this$filterAutoCorrectedIssues.getFindings();
        }
        HashMap filteredFindings = new HashMap();
        Map<String, List<Finding>> $this$forEach$iv = $this$filterAutoCorrectedIssues.getFindings();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<Finding>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv;
            Map.Entry<String, List<Finding>> element$iv;
            Map.Entry<String, List<Finding>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String ruleSetId = entry.getKey();
            List<Finding> findingsList = entry.getValue();
            Iterable $this$filter$iv = findingsList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Finding finding = (Finding)element$iv$iv;
                boolean bl2 = false;
                CorrectableCodeSmell correctableCodeSmell = finding instanceof CorrectableCodeSmell ? (CorrectableCodeSmell)finding : null;
                if (!(correctableCodeSmell == null || !correctableCodeSmell.getAutoCorrectEnabled())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newFindingsList = (List)destination$iv$iv;
            ((Map)filteredFindings).put(ruleSetId, newFindingsList);
        }
        return filteredFindings;
    }

    private static final String truncatedMessage(Finding $this$truncatedMessage) {
        CharSequence charSequence = $this$truncatedMessage.messageOrDescription();
        Regex regex = messageReplacementRegex;
        String string2 = " ";
        String message = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string2))).toString();
        return message.length() > 80 ? StringsKt.take(message, 80) + "(...)" : message;
    }

    private static final String detailed(Finding $this$detailed) {
        return $this$detailed instanceof ThresholdedCodeSmell ? ((ThresholdedCodeSmell)$this$detailed).getId() + " - " + ((ThresholdedCodeSmell)$this$detailed).getMetric() + " - [" + ReportingKt.truncatedMessage($this$detailed) + "] at " + $this$detailed.getLocation().compact() : $this$detailed.getId() + " - [" + ReportingKt.truncatedMessage($this$detailed) + "] at " + $this$detailed.getLocation().compact();
    }
}

