/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.reporting;

import io.github.detekt.tooling.api.spec.ReportsSpec;
import io.gitlab.arturbosch.detekt.api.ConsoleReport;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.OutputReport;
import io.gitlab.arturbosch.detekt.api.PropertiesAware;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.reporting.ConsoleReportLocator;
import io.gitlab.arturbosch.detekt.core.reporting.OutputReportLocator;
import io.gitlab.arturbosch.detekt.core.reporting.ReportingKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/core/reporting/OutputFacade;", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "<init>", "(Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;)V", "reports", "", "", "Lio/github/detekt/tooling/api/spec/ReportsSpec$Report;", "run", "", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "handleConsoleReports", "handleOutputReports", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nOutputFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutputFacade.kt\nio/gitlab/arturbosch/detekt/core/reporting/OutputFacade\n+ 2 PropertiesAware.kt\nio/gitlab/arturbosch/detekt/api/PropertiesAwareKt\n+ 3 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n29#2:49\n27#2,2:50\n31#2:53\n40#3:52\n1202#4,2:54\n1230#4,4:56\n*S KotlinDebug\n*F\n+ 1 OutputFacade.kt\nio/gitlab/arturbosch/detekt/core/reporting/OutputFacade\n*L\n16#1:49\n16#1:50,2\n16#1:53\n16#1:52\n17#1:54,2\n17#1:56,4\n*E\n"})
public final class OutputFacade {
    @NotNull
    private final ProcessingSettings settings;
    @NotNull
    private final Map<String, ReportsSpec.Report> reports;

    /*
     * WARNING - void declaration
     */
    public OutputFacade(@NotNull ProcessingSettings settings) {
        Map map2;
        Map map3;
        Collection collection;
        Collection collection2;
        Iterable $this$getOrNull$iv;
        Intrinsics.checkNotNullParameter(settings, "settings");
        this.settings = settings;
        OutputFacade outputFacade = this;
        PropertiesAware propertiesAware = this.settings;
        String key$iv = "detekt.output.report.paths.key";
        boolean $i$f$getOrNull = false;
        Object value$iv = $this$getOrNull$iv.getProperties().get(key$iv);
        if (value$iv != null) {
            Object $this$safeAs$iv$iv = value$iv;
            boolean $i$f$safeAs = false;
            Object object = $this$safeAs$iv$iv;
            if (!(object instanceof Collection)) {
                object = null;
            }
            if ((collection2 = (Collection)object) == null) {
                throw new IllegalStateException(("No value of type ''" + Reflection.getOrCreateKotlinClass(Collection.class) + " for key '" + key$iv + "'.").toString());
            }
        } else {
            collection2 = null;
        }
        if ((collection = collection2) != null) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            $this$getOrNull$iv = collection;
            OutputFacade outputFacade2 = outputFacade;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            value$iv = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ReportsSpec.Report report2 = (ReportsSpec.Report)element$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                map4.put(it.getType(), element$iv$iv);
            }
            map3 = destination$iv$iv;
            outputFacade = outputFacade2;
        } else {
            map3 = map2 = null;
        }
        if (map3 == null) {
            map2 = MapsKt.emptyMap();
        }
        outputFacade.reports = map2;
    }

    public final void run(@NotNull Detektion result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.handleOutputReports(result2);
        this.handleConsoleReports(result2);
    }

    private final void handleConsoleReports(Detektion result2) {
        List extensions = new ConsoleReportLocator(this.settings).load();
        for (ConsoleReport extension : extensions) {
            String output2 = extension.render(result2);
            CharSequence charSequence = output2;
            if (charSequence == null || StringsKt.isBlank(charSequence)) continue;
            Appendable appendable = this.settings.getOutputChannel().append(output2);
            Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
            Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
        }
    }

    private final void handleOutputReports(Detektion result2) {
        List extensions = new OutputReportLocator(this.settings).load();
        for (OutputReport report2 : extensions) {
            ReportsSpec.Report report3 = this.reports.get(ReportingKt.defaultReportMapping(report2.getId()));
            Path filePath = report3 != null ? report3.getPath() : null;
            if (filePath == null) continue;
            report2.write(filePath, result2);
            result2.add(new SimpleNotification("Successfully generated " + report2.getName() + " at " + filePath.toUri(), null, 2, null));
        }
    }
}

