/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config.validation;

import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.RuleSetProvider;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import io.gitlab.arturbosch.detekt.core.config.validation.AbstractYamlConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidationSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0002J>\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\"\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/MissingRulesConfigValidator;", "Lio/gitlab/arturbosch/detekt/core/config/validation/AbstractYamlConfigValidator;", "baseline", "Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;", "excludePatterns", "", "Lkotlin/text/Regex;", "<init>", "(Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;Ljava/util/Set;)V", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "configToValidate", "settings", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidationSettings;", "validateRuleSet", "", "ruleSet", "", "checkForMissingRules", "ruleSetName", "ruleSetConfigToValidate", "", "", "ruleSetConfigFromBaseline", "ruleMissing", "ruleName", "ruleSetMissing", "getSubMapOrNull", "propertyName", "Companion", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nMissingRulesConfigValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingRulesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/MissingRulesConfigValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1368#2:81\n1454#2,5:82\n774#2:87\n865#2:88\n2632#2,3:89\n866#2:92\n774#2:93\n865#2,2:94\n1557#2:96\n1628#2,3:97\n*S KotlinDebug\n*F\n+ 1 MissingRulesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/MissingRulesConfigValidator\n*L\n22#1:81\n22#1:82,5\n48#1:87\n48#1:88\n48#1:89,3\n48#1:92\n49#1:93\n49#1:94,2\n50#1:96\n50#1:97,3\n*E\n"})
public final class MissingRulesConfigValidator
extends AbstractYamlConfigValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YamlConfig baseline;
    @NotNull
    private final Set<Regex> excludePatterns;
    @NotNull
    private static final Lazy<List<String>> ruleSetNames$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>((Object)Companion){

        public final List<String> invoke() {
            return io.gitlab.arturbosch.detekt.core.config.validation.MissingRulesConfigValidator$Companion.access$loadRuleSets((Companion)this.receiver);
        }
    });

    public MissingRulesConfigValidator(@NotNull YamlConfig baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter(baseline, "baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, "excludePatterns");
        this.baseline = baseline;
        this.excludePatterns = excludePatterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Notification> validate(@NotNull YamlConfig configToValidate, @NotNull ValidationSettings settings) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(configToValidate, "configToValidate");
        Intrinsics.checkNotNullParameter(settings, "settings");
        if (!settings.getCheckExhaustiveness()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = MissingRulesConfigValidator.Companion.getRuleSetNames();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String ruleSet = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.validateRuleSet(ruleSet, configToValidate);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Notification> validateRuleSet(String ruleSet, YamlConfig configToValidate) {
        Map<String, Object> ruleSetConfigToValidate = this.getSubMapOrNull(configToValidate, ruleSet);
        Map<String, Object> ruleSetConfigFromBaseline = this.getSubMapOrNull(this.baseline, ruleSet);
        return ruleSetConfigFromBaseline == null ? CollectionsKt.emptyList() : (ruleSetConfigToValidate == null ? CollectionsKt.listOf(this.ruleSetMissing(ruleSet)) : this.checkForMissingRules(ruleSet, ruleSetConfigToValidate, ruleSetConfigFromBaseline));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Notification> checkForMissingRules(String ruleSetName, Map<String, ? extends Object> ruleSetConfigToValidate, Map<String, ? extends Object> ruleSetConfigFromBaseline) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String ruleName;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (Intrinsics.areEqual(ruleSetConfigToValidate.get("active"), false)) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = ruleSetConfigFromBaseline.keySet();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block7: {
                String ruleNameCandidate = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = this.excludePatterns;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl3 = false;
                        if (!it.matches(ruleSetName + '>' + ruleNameCandidate)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ruleName = (String)element$iv$iv;
            boolean bl = false;
            if (!(!ruleSetConfigToValidate.containsKey(ruleName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ruleName = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.ruleMissing(ruleName, ruleSetName));
        }
        return (List)destination$iv$iv;
    }

    private final Notification ruleMissing(String ruleName, String ruleSetName) {
        return new SimpleNotification("Rule '" + ruleName + "' from the '" + ruleSetName + "' rule set is missing in the configuration.", Notification.Level.Warning);
    }

    private final Notification ruleSetMissing(String ruleSetName) {
        return new SimpleNotification("Rule set '" + ruleSetName + "' is missing in the configuration.", Notification.Level.Warning);
    }

    private final Map<String, Object> getSubMapOrNull(YamlConfig $this$getSubMapOrNull, String propertyName) {
        Object object = $this$getSubMapOrNull.getProperties().get(propertyName);
        return object instanceof Map ? (Map)object : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/MissingRulesConfigValidator$Companion;", "", "<init>", "()V", "ruleSetNames", "", "", "getRuleSetNames", "()Ljava/util/List;", "ruleSetNames$delegate", "Lkotlin/Lazy;", "loadRuleSets", "detekt-core"})
    @SourceDebugExtension(value={"SMAP\nMissingRulesConfigValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingRulesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/MissingRulesConfigValidator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1557#2:81\n1628#2,3:82\n*S KotlinDebug\n*F\n+ 1 MissingRulesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/MissingRulesConfigValidator$Companion\n*L\n76#1:81\n76#1:82,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> getRuleSetNames() {
            Lazy lazy = ruleSetNames$delegate;
            return (List)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> loadRuleSets() {
            void $this$mapTo$iv$iv;
            ServiceLoader<RuleSetProvider> serviceLoader = ServiceLoader.load(RuleSetProvider.class, MissingRulesConfigValidator.class.getClassLoader());
            Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
            Iterable $this$map$iv = serviceLoader;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RuleSetProvider ruleSetProvider = (RuleSetProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRuleSetId());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ List access$loadRuleSets(Companion $this) {
            return $this.loadRuleSets();
        }
    }
}

