/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.baseline;

import io.github.detekt.tooling.api.Baseline;
import io.gitlab.arturbosch.detekt.core.baseline.BaselineFormat;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B+\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0004j\u0002`\u000fH\u0016J\u0013\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0003J\u0013\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001e\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/DefaultBaseline;", "Lio/github/detekt/tooling/api/Baseline;", "manuallySuppressedIssues", "", "", "Lio/github/detekt/tooling/api/FindingsIdList;", "currentIssues", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "getManuallySuppressedIssues", "()Ljava/util/Set;", "getCurrentIssues", "contains", "", "id", "Lio/github/detekt/tooling/api/FindingId;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "detekt-core"})
public final class DefaultBaseline
implements Baseline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> manuallySuppressedIssues;
    @NotNull
    private final Set<String> currentIssues;

    public DefaultBaseline(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, "manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, "currentIssues");
        this.manuallySuppressedIssues = manuallySuppressedIssues;
        this.currentIssues = currentIssues;
    }

    @Override
    @NotNull
    public Set<String> getManuallySuppressedIssues() {
        return this.manuallySuppressedIssues;
    }

    @Override
    @NotNull
    public Set<String> getCurrentIssues() {
        return this.currentIssues;
    }

    @Override
    public boolean contains(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return this.getCurrentIssues().contains(id) || this.getManuallySuppressedIssues().contains(id);
    }

    @NotNull
    public final Set<String> component1() {
        return this.manuallySuppressedIssues;
    }

    @NotNull
    public final Set<String> component2() {
        return this.currentIssues;
    }

    @NotNull
    public final DefaultBaseline copy(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, "manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, "currentIssues");
        return new DefaultBaseline(manuallySuppressedIssues, currentIssues);
    }

    public static /* synthetic */ DefaultBaseline copy$default(DefaultBaseline defaultBaseline, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            set = defaultBaseline.manuallySuppressedIssues;
        }
        if ((n & 2) != 0) {
            set2 = defaultBaseline.currentIssues;
        }
        return defaultBaseline.copy(set, set2);
    }

    @NotNull
    public String toString() {
        return "DefaultBaseline(manuallySuppressedIssues=" + this.manuallySuppressedIssues + ", currentIssues=" + this.currentIssues + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.manuallySuppressedIssues).hashCode();
        result2 = result2 * 31 + ((Object)this.currentIssues).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultBaseline)) {
            return false;
        }
        DefaultBaseline defaultBaseline = (DefaultBaseline)other;
        if (!Intrinsics.areEqual(this.manuallySuppressedIssues, defaultBaseline.manuallySuppressedIssues)) {
            return false;
        }
        return Intrinsics.areEqual(this.currentIssues, defaultBaseline.currentIssues);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/DefaultBaseline$Companion;", "", "<init>", "()V", "load", "Lio/github/detekt/tooling/api/Baseline;", "baselineFile", "Ljava/nio/file/Path;", "detekt-core"})
    @SourceDebugExtension(value={"SMAP\nDefaultBaseline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultBaseline.kt\nio/gitlab/arturbosch/detekt/core/baseline/DefaultBaseline$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Baseline load(@NotNull Path baselineFile) {
            Intrinsics.checkNotNullParameter(baselineFile, "baselineFile");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(baselineFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-DefaultBaseline$Companion$load$32 = false;
                String $i$a$-require-DefaultBaseline$Companion$load$32 = "Baseline file does not exist.";
                throw new IllegalArgumentException($i$a$-require-DefaultBaseline$Companion$load$32.toString());
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isRegularFile(baselineFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                boolean bl = false;
                String string2 = "Baseline file is not a regular file.";
                throw new IllegalArgumentException(string2.toString());
            }
            return new BaselineFormat().read(baselineFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

