/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.github.detekt.tooling.api.spec.ProcessingSpec;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.PropertiesAware;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.core.TaskPool;
import io.gitlab.arturbosch.detekt.core.config.ConfigurationsKt;
import io.gitlab.arturbosch.detekt.core.settings.ClassloaderAware;
import io.gitlab.arturbosch.detekt.core.settings.EnvironmentAware;
import io.gitlab.arturbosch.detekt.core.settings.EnvironmentFacade;
import io.gitlab.arturbosch.detekt.core.settings.ExtensionFacade;
import io.gitlab.arturbosch.detekt.core.settings.LoggingAware;
import io.gitlab.arturbosch.detekt.core.settings.LoggingFacade;
import io.gitlab.arturbosch.detekt.core.settings.PropertiesFacade;
import java.io.Closeable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u00072\u00020\bB\u0017\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u001fH\u0096\u0001J\u0017\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0096\u0001J\u0019\u0010%\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0096\u0001J\u0011\u0010'\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020$H\u0096\u0001J\u0019\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0096\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020$0-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u000205X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0016\u00108\u001a\u000609j\u0002`:X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0016\u0010=\u001a\u000609j\u0002`:X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b>\u0010<R\u0012\u0010?\u001a\u00020@X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR \u0010C\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010+0DX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bE\u0010F\u00a8\u0006G"}, d2={"Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Ljava/io/Closeable;", "Lio/gitlab/arturbosch/detekt/core/settings/LoggingAware;", "Lio/gitlab/arturbosch/detekt/api/PropertiesAware;", "Lio/gitlab/arturbosch/detekt/core/settings/EnvironmentAware;", "Lio/gitlab/arturbosch/detekt/core/settings/ClassloaderAware;", "Lio/gitlab/arturbosch/detekt/api/SetupContext;", "spec", "Lio/github/detekt/tooling/api/spec/ProcessingSpec;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/github/detekt/tooling/api/spec/ProcessingSpec;Lio/gitlab/arturbosch/detekt/api/Config;)V", "getSpec", "()Lio/github/detekt/tooling/api/spec/ProcessingSpec;", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "configUris", "", "Ljava/net/URI;", "getConfigUris", "()Ljava/util/Collection;", "taskPool", "Lio/gitlab/arturbosch/detekt/core/TaskPool;", "getTaskPool", "()Lio/gitlab/arturbosch/detekt/core/TaskPool;", "taskPool$delegate", "Lkotlin/Lazy;", "close", "", "closeLoaderIfNeeded", "debug", "msg", "Lkotlin/Function0;", "", "error", "", "info", "register", "key", "value", "", "classpath", "", "getClasspath", "()Ljava/util/List;", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "getDisposable", "()Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "errorChannel", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "getErrorChannel", "()Ljava/lang/Appendable;", "outputChannel", "getOutputChannel", "pluginLoader", "Ljava/lang/ClassLoader;", "getPluginLoader", "()Ljava/lang/ClassLoader;", "properties", "", "getProperties", "()Ljava/util/Map;", "detekt-core"})
public final class ProcessingSettings
implements AutoCloseable,
Closeable,
LoggingAware,
PropertiesAware,
EnvironmentAware,
ClassloaderAware,
SetupContext {
    private final /* synthetic */ LoggingFacade $$delegate_0;
    private final /* synthetic */ PropertiesFacade $$delegate_1;
    private final /* synthetic */ EnvironmentFacade $$delegate_2;
    private final /* synthetic */ ExtensionFacade $$delegate_3;
    @NotNull
    private final ProcessingSpec spec;
    @NotNull
    private final Config config;
    @NotNull
    private final Collection<URI> configUris;
    @NotNull
    private final Lazy taskPool$delegate;

    public ProcessingSettings(@NotNull ProcessingSpec spec, @NotNull Config config) {
        Intrinsics.checkNotNullParameter(spec, "spec");
        Intrinsics.checkNotNullParameter(config, "config");
        this.$$delegate_0 = new LoggingFacade(spec.getLoggingSpec());
        this.$$delegate_1 = new PropertiesFacade();
        this.$$delegate_2 = new EnvironmentFacade(spec.getProjectSpec(), spec.getCompilerSpec(), spec.getLoggingSpec());
        this.$$delegate_3 = new ExtensionFacade(spec.getExtensionsSpec().getPlugins());
        this.spec = spec;
        this.config = config;
        this.configUris = ConfigurationsKt.extractUris(this.spec.getConfigSpec());
        this.taskPool$delegate = LazyKt.lazy(() -> ProcessingSettings.taskPool_delegate$lambda$0(this));
    }

    @NotNull
    public final ProcessingSpec getSpec() {
        return this.spec;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public Collection<URI> getConfigUris() {
        return this.configUris;
    }

    @NotNull
    public final TaskPool getTaskPool() {
        Lazy lazy = this.taskPool$delegate;
        return (TaskPool)lazy.getValue();
    }

    @Override
    public void close() {
        ExceptionUtilsKt.closeQuietly(this.getTaskPool());
        Disposer.dispose(this.getDisposable());
        this.closeLoaderIfNeeded();
    }

    @Override
    @NotNull
    public Appendable getOutputChannel() {
        return this.$$delegate_0.getOutputChannel();
    }

    @Override
    @NotNull
    public Appendable getErrorChannel() {
        return this.$$delegate_0.getErrorChannel();
    }

    @Override
    public void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.$$delegate_0.info(msg);
    }

    @Override
    public void error(@NotNull String msg, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(error, "error");
        this.$$delegate_0.error(msg, error);
    }

    @Override
    public void debug(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.$$delegate_0.debug(msg);
    }

    @Override
    public void register(@NotNull String key, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.$$delegate_1.register(key, value2);
    }

    @Override
    @NotNull
    public Map<String, Object> getProperties() {
        return this.$$delegate_1.getProperties();
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        return this.$$delegate_2.getDisposable();
    }

    @Override
    @NotNull
    public List<String> getClasspath() {
        return this.$$delegate_2.getClasspath();
    }

    @Override
    @NotNull
    public KotlinCoreEnvironment getEnvironment() {
        return this.$$delegate_2.getEnvironment();
    }

    @Override
    @NotNull
    public ClassLoader getPluginLoader() {
        return this.$$delegate_3.getPluginLoader();
    }

    @Override
    public void closeLoaderIfNeeded() {
        this.$$delegate_3.closeLoaderIfNeeded();
    }

    private static final TaskPool taskPool_delegate$lambda$0(ProcessingSettings this$0) {
        return new TaskPool(this$0.spec.getExecutionSpec().getExecutorService());
    }
}

