/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.github.detekt.parser.KtCompiler;
import io.github.detekt.tooling.api.spec.ProjectSpec;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.core.KtTreeCompiler;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.TaskPool;
import io.gitlab.arturbosch.detekt.core.TaskPoolKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler;", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "projectSpec", "Lio/github/detekt/tooling/api/spec/ProjectSpec;", "compiler", "Lio/github/detekt/parser/KtCompiler;", "<init>", "(Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;Lio/github/detekt/tooling/api/spec/ProjectSpec;Lio/github/detekt/parser/KtCompiler;)V", "basePath", "Ljava/nio/file/Path;", "pathFilters", "Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "compile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "path", "compileProject", "project", "isKotlinFile", "", "isIgnored", "Companion", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nKtTreeCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtTreeCompiler.kt\nio/gitlab/arturbosch/detekt/core/KtTreeCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class KtTreeCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessingSettings settings;
    @NotNull
    private final KtCompiler compiler;
    @Nullable
    private final Path basePath;
    @Nullable
    private final PathFilters pathFilters;
    @NotNull
    private static final Set<String> KT_ENDINGS;

    public KtTreeCompiler(@NotNull ProcessingSettings settings, @NotNull ProjectSpec projectSpec, @NotNull KtCompiler compiler) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(projectSpec, "projectSpec");
        Intrinsics.checkNotNullParameter(compiler, "compiler");
        this.settings = settings;
        this.compiler = compiler;
        this.basePath = projectSpec.getBasePath();
        this.pathFilters = PathFilters.Companion.of(CollectionsKt.toList((Iterable)projectSpec.getIncludes()), CollectionsKt.toList((Iterable)projectSpec.getExcludes()));
    }

    public /* synthetic */ KtTreeCompiler(ProcessingSettings processingSettings, ProjectSpec projectSpec, KtCompiler ktCompiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ktCompiler = new KtCompiler(processingSettings.getEnvironment());
        }
        this(processingSettings, projectSpec, ktCompiler);
    }

    @NotNull
    public final List<KtFile> compile(@NotNull Path path) {
        List<KtFile> list;
        Intrinsics.checkNotNullParameter(path, "path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string2 = "Given path " + path + " does not exist!";
            throw new IllegalArgumentException(string2.toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isRegularFile(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && this.isKotlinFile(path)) {
            list = CollectionsKt.listOf(this.compiler.compile(this.basePath, path));
        } else {
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                list = this.compileProject(path);
            } else {
                this.settings.debug(() -> KtTreeCompiler.compile$lambda$1(path));
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    private final List<KtFile> compileProject(Path project) {
        Stream<Path> stream = Files.walk(project, new FileVisitOption[0]);
        Intrinsics.checkNotNullExpressionValue(stream, "walk(...)");
        Sequence<Path> kotlinFiles2 = SequencesKt.filter(SequencesKt.filter(SequencesKt.filter(StreamsKt.asSequence(stream), compileProject.kotlinFiles.1.INSTANCE), arg_0 -> KtTreeCompiler.compileProject$lambda$2(this, arg_0)), arg_0 -> KtTreeCompiler.compileProject$lambda$3(this, arg_0));
        if (this.settings.getSpec().getExecutionSpec().getParallelParsing()) {
            TaskPool service = this.settings.getTaskPool();
            List<CompletableFuture> tasks = SequencesKt.toList(SequencesKt.map(kotlinFiles2, arg_0 -> KtTreeCompiler.compileProject$lambda$6(service, this, arg_0)));
            return CollectionsKt.filterNotNull(TaskPoolKt.awaitAll(tasks));
        }
        return SequencesKt.toList(SequencesKt.map(kotlinFiles2, arg_0 -> KtTreeCompiler.compileProject$lambda$7(this, arg_0)));
    }

    private final boolean isKotlinFile(Path $this$isKotlinFile) {
        return KT_ENDINGS.contains(PathsKt.getExtension($this$isKotlinFile));
    }

    private final boolean isIgnored(Path path) {
        Boolean ignored;
        PathFilters pathFilters = this.pathFilters;
        Boolean bl = ignored = pathFilters != null ? Boolean.valueOf(pathFilters.isIgnored(path)) : null;
        if (Intrinsics.areEqual(ignored, true)) {
            this.settings.debug(() -> KtTreeCompiler.isIgnored$lambda$8(path));
        }
        Boolean bl2 = ignored;
        return bl2 != null ? bl2 : false;
    }

    private static final String compile$lambda$1(Path $path) {
        return "Ignoring a file detekt cannot handle: " + $path;
    }

    private static final boolean compileProject$lambda$2(KtTreeCompiler this$0, Path it) {
        Intrinsics.checkNotNull(it);
        return this$0.isKotlinFile(it);
    }

    private static final boolean compileProject$lambda$3(KtTreeCompiler this$0, Path it) {
        Intrinsics.checkNotNull(it);
        return !this$0.isIgnored(it);
    }

    private static final KtFile compileProject$lambda$6$lambda$4(KtTreeCompiler this$0, Path $path) {
        KtCompiler ktCompiler = this$0.compiler;
        Path path = this$0.basePath;
        Intrinsics.checkNotNull($path);
        return ktCompiler.compile(path, $path);
    }

    private static final KtFile compileProject$lambda$6$lambda$5(KtTreeCompiler this$0, Path $path, Throwable it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.settings.error("Could not compile '" + $path + "'.", it);
        return null;
    }

    private static final CompletableFuture compileProject$lambda$6(TaskPool $service, KtTreeCompiler this$0, Path path) {
        return TaskPoolKt.recover(TaskPoolKt.task($service, () -> KtTreeCompiler.compileProject$lambda$6$lambda$4(this$0, path)), arg_0 -> KtTreeCompiler.compileProject$lambda$6$lambda$5(this$0, path, arg_0));
    }

    private static final KtFile compileProject$lambda$7(KtTreeCompiler this$0, Path it) {
        KtCompiler ktCompiler = this$0.compiler;
        Path path = this$0.basePath;
        Intrinsics.checkNotNull(it);
        return ktCompiler.compile(path, it);
    }

    private static final String isIgnored$lambda$8(Path $path) {
        return "Ignoring file '" + $path + '\'';
    }

    static {
        String[] stringArray = new String[]{"kt", "kts"};
        KT_ENDINGS = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler$Companion;", "", "<init>", "()V", "KT_ENDINGS", "", "", "getKT_ENDINGS", "()Ljava/util/Set;", "detekt-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getKT_ENDINGS() {
            return KT_ENDINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

