/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.MultiRule;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.RuleSet;
import io.gitlab.arturbosch.detekt.api.RuleSetProvider;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.core.AnalyzerKt;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.TaskPool;
import io.gitlab.arturbosch.detekt.core.TaskPoolKt;
import io.gitlab.arturbosch.detekt.core.rules.RuleSetsKt;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactoryImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ4\u0010\r\u001a\u0018\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0016JF\u0010\u0017\u001a\"\u0012\u001a\u0012\u0018\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u000e0\u0005j\u0002`\u00182\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JF\u0010\u001b\u001a\"\u0012\u001a\u0012\u0018\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u000e0\u0005j\u0002`\u00182\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J6\u0010\u001c\u001a\u0018\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u000e2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/core/Analyzer;", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "providers", "", "Lio/gitlab/arturbosch/detekt/api/RuleSetProvider;", "processors", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "<init>", "(Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;Ljava/util/List;Ljava/util/List;)V", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "run", "", "", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "Lio/gitlab/arturbosch/detekt/api/Finding;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "runSync", "Lio/gitlab/arturbosch/detekt/core/FindingsResult;", "compilerResources", "Lio/gitlab/arturbosch/detekt/api/internal/CompilerResources;", "runAsync", "analyze", "file", "warnAboutEnabledRequiresTypeResolutionRules", "", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Analyzer.kt\nio/gitlab/arturbosch/detekt/core/Analyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,218:1\n1557#2:219\n1628#2,2:220\n1863#2,2:222\n1863#2,2:225\n1630#2:227\n1557#2:228\n1628#2,3:229\n1863#2,2:244\n1863#2,2:246\n1755#2,3:248\n295#2,2:253\n295#2,2:257\n1#3:224\n2707#4,10:232\n1317#4,2:242\n29#5:251\n20#5:252\n29#5:255\n20#5:256\n*S KotlinDebug\n*F\n+ 1 Analyzer.kt\nio/gitlab/arturbosch/detekt/core/Analyzer\n*L\n72#1:219\n72#1:220,2\n73#1:222,2\n77#1:225,2\n72#1:227\n87#1:228\n87#1:229,3\n89#1:244,2\n91#1:246,2\n106#1:248,3\n123#1:253,2\n155#1:257,2\n125#1:232,10\n156#1:242,2\n123#1:251\n123#1:252\n155#1:255\n155#1:256\n*E\n"})
public final class Analyzer {
    @NotNull
    private final ProcessingSettings settings;
    @NotNull
    private final List<RuleSetProvider> providers;
    @NotNull
    private final List<FileProcessListener> processors;
    @NotNull
    private final Config config;

    public Analyzer(@NotNull ProcessingSettings settings, @NotNull List<? extends RuleSetProvider> providers, @NotNull List<? extends FileProcessListener> processors) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(providers, "providers");
        Intrinsics.checkNotNullParameter(processors, "processors");
        this.settings = settings;
        this.providers = providers;
        this.processors = processors;
        this.config = AnalyzerKt.workaroundConfiguration(this.settings.getSpec(), this.settings.getConfig());
    }

    @NotNull
    public final Map<String, List<Finding>> run(@NotNull Collection<? extends KtFile> ktFiles, @NotNull BindingContext bindingContext) {
        List<Map<String, List<Finding>>> findingsPerFile;
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.settings.getEnvironment().getConfiguration());
        DataFlowValueFactoryImpl dataFlowValueFactory = new DataFlowValueFactoryImpl(languageVersionSettings);
        CompilerResources compilerResources = new CompilerResources(languageVersionSettings, dataFlowValueFactory);
        List<Map<String, List<Finding>>> list = findingsPerFile = this.settings.getSpec().getExecutionSpec().getParallelAnalysis() ? this.runAsync(ktFiles, bindingContext, compilerResources) : this.runSync(ktFiles, bindingContext, compilerResources);
        if (Intrinsics.areEqual(bindingContext, BindingContext.EMPTY)) {
            this.warnAboutEnabledRequiresTypeResolutionRules();
        }
        HashMap findingsPerRuleSet = new HashMap();
        for (Map<String, List<Finding>> findings : findingsPerFile) {
            AnalyzerKt.access$mergeSmells(findingsPerRuleSet, findings);
        }
        return findingsPerRuleSet;
    }

    public static /* synthetic */ Map run$default(Analyzer analyzer2, Collection collection, BindingContext bindingContext, int n, Object object) {
        if ((n & 2) != 0) {
            bindingContext = BindingContext.EMPTY;
        }
        return analyzer2.run(collection, bindingContext);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, List<Finding>>> runSync(Collection<? extends KtFile> ktFiles, BindingContext bindingContext, CompilerResources compilerResources) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ktFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map $this$runSync_u24lambda_u244_u24lambda_u241;
            void file2;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.processors;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                FileProcessListener it = (FileProcessListener)element$iv;
                boolean bl2 = false;
                it.onProcess((KtFile)file2, bindingContext);
            }
            Object $i$f$forEach22 = this;
            try {
                $this$runSync_u24lambda_u244_u24lambda_u241 = $i$f$forEach22;
                boolean bl3 = false;
                $this$runSync_u24lambda_u244_u24lambda_u241 = Result.constructor-impl(super.analyze((KtFile)file2, bindingContext, compilerResources));
            }
            catch (Throwable bl3) {
                $this$runSync_u24lambda_u244_u24lambda_u241 = Result.constructor-impl(ResultKt.createFailure(bl3));
            }
            $i$f$forEach22 = $this$runSync_u24lambda_u244_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl($i$f$forEach22);
            if (throwable != null) {
                Map it = $this$runSync_u24lambda_u244_u24lambda_u241 = throwable;
                boolean bl4 = false;
                AnalyzerKt.access$throwIllegalStateException((KtFile)file2, it);
                throw new KotlinNothingValueException();
            }
            $this$runSync_u24lambda_u244_u24lambda_u241 = MapsKt.emptyMap();
            Map findings = (Map)(Result.isFailure-impl($i$f$forEach22) ? $this$runSync_u24lambda_u244_u24lambda_u241 : $i$f$forEach22);
            Iterable $this$forEach$iv2 = this.processors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                FileProcessListener it = (FileProcessListener)element$iv;
                boolean bl5 = false;
                it.onProcessComplete((KtFile)file2, findings, bindingContext);
            }
            collection.add(findings);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, List<Finding>>> runAsync(Collection<? extends KtFile> ktFiles, BindingContext bindingContext, CompilerResources compilerResources) {
        void $this$mapTo$iv$iv;
        TaskPool service = this.settings.getTaskPool();
        Iterable $this$map$iv = ktFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file2;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TaskPoolKt.recover(TaskPoolKt.task(service, () -> Analyzer.runAsync$lambda$9$lambda$7(this, (KtFile)file2, bindingContext, compilerResources)), arg_0 -> Analyzer.runAsync$lambda$9$lambda$8((KtFile)file2, arg_0)));
        }
        List tasks = (List)destination$iv$iv;
        return CollectionsKt.filterNotNull(TaskPoolKt.awaitAll(tasks));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<Finding>> analyze(KtFile file2, BindingContext bindingContext, CompilerResources compilerResources) {
        void $this$partition$iv;
        Sequence<Pair> activeRuleSetsToRuleSetConfigs = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.providers), arg_0 -> Analyzer.analyze$lambda$11(this, arg_0)), Analyzer::analyze$lambda$12), Analyzer::analyze$lambda$13), arg_0 -> Analyzer.analyze$lambda$14(file2, arg_0));
        Map<String, String> ruleIdsToRuleSetIds = RuleSetsKt.associateRuleIdsToRuleSetIds(SequencesKt.map(activeRuleSetsToRuleSetConfigs, Analyzer::analyze$lambda$15));
        Sequence<BaseRule> sequence2 = SequencesKt.filter(SequencesKt.flatMap(activeRuleSetsToRuleSetConfigs, Analyzer::analyze$lambda$16), arg_0 -> Analyzer.analyze$lambda$17(bindingContext, arg_0));
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            BaseRule it = (BaseRule)element$iv;
            boolean bl = false;
            if (Analyzer.analyze$isCorrectable(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List correctableRules = pair.component1();
        List otherRules = pair.component2();
        HashMap<String, List<Finding>> result2 = new HashMap<String, List<Finding>>();
        Analyzer.analyze$executeRules(file2, bindingContext, compilerResources, ruleIdsToRuleSetIds, result2, correctableRules);
        Analyzer.analyze$executeRules(file2, bindingContext, compilerResources, ruleIdsToRuleSetIds, result2, otherRules);
        return result2;
    }

    private final void warnAboutEnabledRequiresTypeResolutionRules() {
        Sequence<BaseRule> $this$forEach$iv = SequencesKt.filter(SequencesKt.filter(SequencesKt.flatMap(SequencesKt.map(SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.providers), arg_0 -> Analyzer.warnAboutEnabledRequiresTypeResolutionRules$lambda$22(this, arg_0)), Analyzer::warnAboutEnabledRequiresTypeResolutionRules$lambda$23), Analyzer::warnAboutEnabledRequiresTypeResolutionRules$lambda$24), Analyzer::warnAboutEnabledRequiresTypeResolutionRules$lambda$25), Analyzer::warnAboutEnabledRequiresTypeResolutionRules$lambda$26), Analyzer::warnAboutEnabledRequiresTypeResolutionRules$lambda$27);
        boolean $i$f$forEach = false;
        Iterator<BaseRule> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            BaseRule element$iv;
            BaseRule rule = element$iv = iterator2.next();
            boolean bl = false;
            this.settings.debug(() -> Analyzer.warnAboutEnabledRequiresTypeResolutionRules$lambda$29$lambda$28(rule));
        }
    }

    private static final Map runAsync$lambda$9$lambda$7(Analyzer this$0, KtFile $file, BindingContext $bindingContext, CompilerResources $compilerResources) {
        Iterable $this$forEach$iv = this$0.processors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileProcessListener it = (FileProcessListener)element$iv;
            boolean bl = false;
            it.onProcess($file, $bindingContext);
        }
        Map<String, List<Finding>> findings = this$0.analyze($file, $bindingContext, $compilerResources);
        Iterable $this$forEach$iv2 = this$0.processors;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FileProcessListener it = (FileProcessListener)element$iv;
            boolean bl = false;
            it.onProcessComplete($file, findings, $bindingContext);
        }
        return findings;
    }

    private static final Map runAsync$lambda$9$lambda$8(KtFile $file, Throwable it) {
        Intrinsics.checkNotNullParameter(it, "it");
        AnalyzerKt.access$throwIllegalStateException($file, it);
        throw new KotlinNothingValueException();
    }

    private static final boolean analyze$isCorrectable(BaseRule rule) {
        boolean bl;
        block7: {
            BaseRule baseRule = rule;
            if (baseRule instanceof Rule) {
                bl = ((Rule)rule).getAutoCorrect();
            } else if (baseRule instanceof MultiRule) {
                Iterable $this$any$iv = ((MultiRule)rule).getRules();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Rule it = (Rule)element$iv;
                        boolean bl2 = false;
                        if (!it.getAutoCorrect()) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                throw new IllegalStateException("No other rule type expected.".toString());
            }
        }
        return bl;
    }

    private static final Pair analyze$lambda$11(Analyzer this$0, RuleSetProvider it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it, this$0.config.subConfig(it.getRuleSetId()));
    }

    private static final boolean analyze$lambda$12(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        Config ruleSetConfig = (Config)pair.component2();
        return RuleSetsKt.isActive(ruleSetConfig);
    }

    private static final Pair analyze$lambda$13(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        RuleSetProvider provider2 = (RuleSetProvider)pair.component1();
        Config ruleSetConfig = (Config)pair.component2();
        return TuplesKt.to(provider2.instance(ruleSetConfig), ruleSetConfig);
    }

    private static final boolean analyze$lambda$14(KtFile $file, Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        Config ruleSetConfig = (Config)pair.component2();
        return RuleSetsKt.shouldAnalyzeFile(ruleSetConfig, $file);
    }

    private static final RuleSet analyze$lambda$15(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        RuleSet ruleSet = (RuleSet)pair.component1();
        return ruleSet;
    }

    private static final Sequence analyze$lambda$16(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        RuleSet ruleSet = (RuleSet)pair.component1();
        return CollectionsKt.asSequence((Iterable)ruleSet.getRules());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean analyze$lambda$17(BindingContext $bindingContext, BaseRule rule) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(rule, "rule");
            if (!Intrinsics.areEqual($bindingContext, BindingContext.EMPTY)) return true;
            KAnnotatedElement $this$hasAnnotation$iv = Reflection.getOrCreateKotlinClass(rule.getClass());
            boolean $i$f$hasAnnotation = false;
            KAnnotatedElement $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                boolean bl = false;
                if (!(it$iv$iv instanceof RequiresTypeResolution)) continue;
                v0 = element$iv$iv$iv;
                break block1;
            }
            v0 = null;
        }
        if ((Annotation)v0 == null) return true;
        return false;
    }

    private static final List analyze$executeRules$lambda$20(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List analyze$executeRules$lambda$21(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void analyze$executeRules(KtFile $file, BindingContext $bindingContext, CompilerResources $compilerResources, Map<String, String> ruleIdsToRuleSetIds, HashMap<String, List<Finding>> result2, List<? extends BaseRule> rules) {
        for (BaseRule baseRule : rules) {
            baseRule.visitFile($file, $bindingContext, $compilerResources);
            for (Finding finding : AnalyzerKt.access$filterSuppressedFindings(baseRule, $bindingContext)) {
                String mappedRuleSet;
                if (ruleIdsToRuleSetIds.get(finding.getId()) == null) {
                    boolean bl = false;
                    String string2 = "Mapping for '" + finding.getId() + "' expected.";
                    throw new IllegalStateException(string2.toString());
                }
                result2.computeIfAbsent(mappedRuleSet, arg_0 -> Analyzer.analyze$executeRules$lambda$21(Analyzer::analyze$executeRules$lambda$20, arg_0)).add(finding);
            }
        }
    }

    private static final Pair warnAboutEnabledRequiresTypeResolutionRules$lambda$22(Analyzer this$0, RuleSetProvider it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it, this$0.config.subConfig(it.getRuleSetId()));
    }

    private static final boolean warnAboutEnabledRequiresTypeResolutionRules$lambda$23(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        Config ruleSetConfig = (Config)pair.component2();
        return RuleSetsKt.isActive(ruleSetConfig);
    }

    private static final Pair warnAboutEnabledRequiresTypeResolutionRules$lambda$24(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        RuleSetProvider provider2 = (RuleSetProvider)pair.component1();
        Config ruleSetConfig = (Config)pair.component2();
        return TuplesKt.to(provider2.instance(ruleSetConfig), ruleSetConfig);
    }

    private static final Sequence warnAboutEnabledRequiresTypeResolutionRules$lambda$25(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        RuleSet ruleSet = (RuleSet)pair.component1();
        return CollectionsKt.asSequence((Iterable)ruleSet.getRules());
    }

    private static final boolean warnAboutEnabledRequiresTypeResolutionRules$lambda$26(BaseRule rule) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        Rule rule2 = rule instanceof Rule ? (Rule)rule : null;
        return rule2 != null ? rule2.getActive() : false;
    }

    private static final boolean warnAboutEnabledRequiresTypeResolutionRules$lambda$27(BaseRule rule) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(rule, "rule");
            KAnnotatedElement $this$hasAnnotation$iv = Reflection.getOrCreateKotlinClass(rule.getClass());
            boolean $i$f$hasAnnotation = false;
            KAnnotatedElement $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                boolean bl = false;
                if (!(it$iv$iv instanceof RequiresTypeResolution)) continue;
                v0 = element$iv$iv$iv;
                break block1;
            }
            v0 = null;
        }
        return (Annotation)v0 != null;
    }

    private static final String warnAboutEnabledRequiresTypeResolutionRules$lambda$29$lambda$28(BaseRule $rule) {
        return "The rule '" + $rule.getRuleId() + "' requires type resolution but it was run without it.";
    }
}

