/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import io.github.detekt.tooling.api.AnalysisResult;
import io.github.detekt.tooling.api.AnalysisResultKt;
import io.github.detekt.tooling.api.DetektError;
import io.github.detekt.tooling.api.InvalidConfig;
import io.github.detekt.tooling.api.MaxIssuesReached;
import io.github.detekt.tooling.api.UnexpectedError;
import io.github.detekt.tooling.internal.NotApiButProbablyUsedByUsers;
import io.gitlab.arturbosch.detekt.api.internal.VersionsKt;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.CliRunner;
import io.gitlab.arturbosch.detekt.cli.HandledArgumentViolation;
import io.gitlab.arturbosch.detekt.cli.HelpRequest;
import io.gitlab.arturbosch.detekt.cli.JCommanderKt;
import io.gitlab.arturbosch.detekt.cli.runners.ConfigExporter;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import io.gitlab.arturbosch.detekt.cli.runners.Runner;
import io.gitlab.arturbosch.detekt.cli.runners.VersionPrinter;
import java.io.PrintStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a+\u0010\u0006\u001a\u00020\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "buildRunner", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "outputPrinter", "Ljava/io/PrintStream;", "errorPrinter", "([Ljava/lang/String;Ljava/io/PrintStream;Ljava/io/PrintStream;)Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "detekt-cli"})
@JvmName(name="Main")
public final class Main {
    public static final void main(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        AnalysisResult result2 = new CliRunner().run(args2);
        DetektError error = result2.getError();
        if (error instanceof InvalidConfig || error instanceof MaxIssuesReached) {
            System.out.println((Object)error.getMessage());
        } else if (error instanceof UnexpectedError) {
            Throwable cause = ((UnexpectedError)error).getCause();
            if (cause instanceof HelpRequest) {
                System.out.println((Object)((HelpRequest)cause).getUsageText());
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (cause instanceof HandledArgumentViolation) {
                System.out.println((Object)cause.getMessage());
                System.out.println((Object)((HandledArgumentViolation)cause).getUsageText());
            } else {
                cause.printStackTrace();
            }
        }
        System.exit(AnalysisResultKt.exitCode(result2));
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @NotApiButProbablyUsedByUsers
    @Deprecated(message="Don't build a runner yourself.", replaceWith=@ReplaceWith(expression="DetektCli.load().run(args, outputPrinter, errorPrinter)", imports={"io.github.detekt.tooling.api.DetektCli"}))
    @NotNull
    public static final Executable buildRunner(@NotNull String[] args2, @NotNull PrintStream outputPrinter, @NotNull PrintStream errorPrinter) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(outputPrinter, "outputPrinter");
        Intrinsics.checkNotNullParameter(errorPrinter, "errorPrinter");
        if (!Intrinsics.areEqual(KotlinCompilerVersion.VERSION, VersionsKt.whichKotlin())) {
            boolean bl = false;
            String string2 = StringsKt.trimIndent("\n            detekt was compiled with Kotlin " + VersionsKt.whichKotlin() + " but is currently running with " + KotlinCompilerVersion.VERSION + ".\n            This is not supported. See https://detekt.dev/docs/gettingstarted/gradle#dependencies for more information.\n        ");
            throw new IllegalStateException(string2.toString());
        }
        CliArgs arguments = JCommanderKt.parseArguments(args2);
        return arguments.getShowVersion() ? (Executable)new VersionPrinter(outputPrinter) : (arguments.getGenerateConfig() ? (Executable)new ConfigExporter(arguments, outputPrinter) : (Executable)new Runner(arguments, outputPrinter, errorPrinter));
    }
}

