/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.github.detekt.utils.ResourcesKt;
import io.gitlab.arturbosch.detekt.api.Extension;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a8\u0006\u0007"}, d2={"whichOS", "", "whichJava", "whichKotlin", "whichDetekt", "getManifestValue", "key", "detekt-api"})
@SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\nio/gitlab/arturbosch/detekt/api/internal/VersionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class VersionsKt {
    @NotNull
    public static final String whichOS() {
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
        return string2;
    }

    @NotNull
    public static final String whichJava() {
        String string2 = System.getProperty("java.runtime.version");
        Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
        return string2;
    }

    @NotNull
    public static final String whichKotlin() {
        return VersionsKt.getManifestValue("KotlinImplementationVersion");
    }

    @NotNull
    public static final String whichDetekt() {
        return VersionsKt.getManifestValue("DetektVersion");
    }

    private static final String getManifestValue(String key) {
        Enumeration<URL> enumeration = Extension.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        Intrinsics.checkNotNullExpressionValue(enumeration, "getResources(...)");
        return SequencesKt.first(SequencesKt.mapNotNull(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), arg_0 -> VersionsKt.getManifestValue$lambda$2(key, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getManifestValue$readVersion(String $key, URL resource) {
        String string2;
        Closeable closeable = ResourcesKt.openSafeStream(resource);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            string2 = new Manifest(it).getMainAttributes().getValue($key);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return string2;
    }

    private static final String getManifestValue$lambda$2(String $key, URL it) {
        Object object;
        try {
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            object = Result.constructor-impl(VersionsKt.getManifestValue$readVersion($key, it));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        return (String)(Result.isFailure-impl(object) ? null : object);
    }
}

