/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.github.detekt.psi.KtFilesKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\f\u0010\b\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\f\u0010\t\u001a\u00020\u0003*\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"multipleWhitespaces", "Lkotlin/text/Regex;", "searchName", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "formatElementName", "buildFullSignature", "extractClassName", "searchSignature", "fileSignature", "Lorg/jetbrains/kotlin/psi/KtFile;", "buildClassSignature", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "buildFunctionSignature", "element", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-api"})
@SourceDebugExtension(value={"SMAP\nSignatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signatures.kt\nio/gitlab/arturbosch/detekt/api/internal/SignaturesKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n146#2:112\n1863#3,2:113\n*S KotlinDebug\n*F\n+ 1 Signatures.kt\nio/gitlab/arturbosch/detekt/api/internal/SignaturesKt\n*L\n71#1:112\n94#1:113,2\n*E\n"})
public final class SignaturesKt {
    @NotNull
    private static final Regex multipleWhitespaces = new Regex("\\s{2,}");

    @NotNull
    public static final String searchName(@NotNull PsiElement $this$searchName) {
        Intrinsics.checkNotNullParameter($this$searchName, "<this>");
        Object object = LightClassUtilsKt.getNamedUnwrappedElement($this$searchName);
        if (object == null || (object = object.getName()) == null || (object = SignaturesKt.formatElementName((String)object)) == null) {
            object = "<UnknownName>";
        }
        return object;
    }

    private static final String formatElementName(String $this$formatElementName) {
        return StringsKt.contains$default((CharSequence)$this$formatElementName, File.separatorChar, false, 2, null) ? StringsKt.substringAfterLast$default($this$formatElementName, File.separatorChar, null, 2, null) : $this$formatElementName;
    }

    @NotNull
    public static final String buildFullSignature(@NotNull PsiElement $this$buildFullSignature) {
        Intrinsics.checkNotNullParameter($this$buildFullSignature, "<this>");
        String fullSignature = SignaturesKt.searchSignature($this$buildFullSignature);
        String parentSignatures = CollectionsKt.joinToString$default(CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.map(SequencesKt.filter(PsiUtilsKt.getParents($this$buildFullSignature), SignaturesKt::buildFullSignature$lambda$0), SignaturesKt::buildFullSignature$lambda$1))), ".", null, null, 0, null, null, 62, null);
        if (((CharSequence)parentSignatures).length() > 0) {
            fullSignature = parentSignatures + '$' + fullSignature;
        }
        PsiFile psiFile = $this$buildFullSignature.getContainingFile();
        Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
        String filename = KtFilesKt.getFileName(psiFile);
        if (!StringsKt.startsWith$default(fullSignature, filename, false, 2, null)) {
            fullSignature = filename + '$' + fullSignature;
        }
        return fullSignature;
    }

    private static final String extractClassName(PsiElement $this$extractClassName) {
        String string2;
        PsiElement $this$getNonStrictParentOfType$iv = $this$extractClassName;
        boolean $i$f$getNonStrictParentOfType = false;
        Object object = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtClassOrObject.class, false);
        if ((object != null && (object = ((KtTypeParameterListOwnerStub)object).getNameAsSafeName()) != null ? ((Name)object).asString() : (string2 = null)) == null) {
            string2 = "";
        }
        return string2;
    }

    private static final String searchSignature(PsiElement $this$searchSignature) {
        Object object = $this$searchSignature;
        CharSequence charSequence = object instanceof KtNamedFunction ? SignaturesKt.buildFunctionSignature((KtNamedFunction)$this$searchSignature) : (object instanceof KtClassOrObject ? SignaturesKt.buildClassSignature((KtClassOrObject)$this$searchSignature) : (object instanceof KtFile ? SignaturesKt.fileSignature((KtFile)$this$searchSignature) : $this$searchSignature.getText()));
        Intrinsics.checkNotNull(charSequence);
        charSequence = StringsKt.replace$default(charSequence, '\n', ' ', false, 4, null);
        object = multipleWhitespaces;
        String string2 = " ";
        return ((Regex)object).replace(charSequence, string2);
    }

    private static final String fileSignature(KtFile $this$fileSignature) {
        return $this$fileSignature.getPackageFqName().asString() + '.' + KtFilesKt.getFileName($this$fileSignature);
    }

    private static final String buildClassSignature(KtClassOrObject classOrObject) {
        List<KtSuperTypeListEntry> extendedEntries;
        String baseName = null;
        String string2 = classOrObject.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        baseName = string2;
        List<KtTypeParameter> list = classOrObject.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        List<KtTypeParameter> typeParameters = list;
        if (typeParameters.size() > 0) {
            baseName = baseName + '<';
            baseName = baseName + CollectionsKt.joinToString$default(typeParameters, ", ", null, null, 0, null, SignaturesKt::buildClassSignature$lambda$2, 30, null);
            baseName = baseName + '>';
        }
        if (!((Collection)(extendedEntries = classOrObject.getSuperTypeListEntries())).isEmpty()) {
            baseName = baseName + " : ";
        }
        Iterable $this$forEach$iv = extendedEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(baseName);
            KtUserType ktUserType = it.getTypeAsUserType();
            String string3 = ktUserType != null ? ktUserType.getReferencedName() : null;
            if (string3 == null) {
                string3 = "";
            }
            baseName = stringBuilder.append(string3).toString();
        }
        return baseName;
    }

    private static final String buildFunctionSignature(KtNamedFunction element) {
        int n;
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(element) - PsiUtilsKt.getStartOffset(element);
        if (element.getTypeReference() != null) {
            KtTypeReference ktTypeReference = element.getTypeReference();
            n = ktTypeReference != null ? PsiUtilsKt.getEndOffset(ktTypeReference) : 0;
        } else {
            KtParameterList ktParameterList = element.getValueParameterList();
            n = ktParameterList != null ? PsiUtilsKt.getEndOffset(ktParameterList) : 0;
        }
        int endOffset = n - PsiUtilsKt.getStartOffset(element);
        if (!(startOffset < endOffset)) {
            boolean bl = false;
            String string2 = "Error building function signature with range " + startOffset + " - " + endOffset + " for element: " + element.getText();
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = element.getText();
        Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
        String string4 = string3.substring(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        return string4;
    }

    private static final boolean buildFullSignature$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtClassOrObject;
    }

    private static final String buildFullSignature$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SignaturesKt.extractClassName(it);
    }

    private static final CharSequence buildClassSignature$lambda$2(KtTypeParameter it) {
        String string2 = it.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return string2;
    }
}

