/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigAware;
import io.gitlab.arturbosch.detekt.api.Context;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.SeverityLevel;
import io.gitlab.arturbosch.detekt.api.internal.DefaultContext;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import io.gitlab.arturbosch.detekt.api.internal.SuppressionsKt;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0014\u0010)\u001a\u00020*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00060\u0010j\u0002`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001c\u0010\u001a\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Lio/gitlab/arturbosch/detekt/api/Rule;", "Lio/gitlab/arturbosch/detekt/api/BaseRule;", "Lio/gitlab/arturbosch/detekt/api/ConfigAware;", "ruleSetConfig", "Lio/gitlab/arturbosch/detekt/api/Config;", "ruleContext", "Lio/gitlab/arturbosch/detekt/api/Context;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;Lio/gitlab/arturbosch/detekt/api/Context;)V", "getRuleSetConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ruleId", "", "Lio/gitlab/arturbosch/detekt/api/RuleId;", "getRuleId", "()Ljava/lang/String;", "aliases", "", "getAliases", "()Ljava/util/Set;", "defaultRuleIdAliases", "getDefaultRuleIdAliases", "ruleSetId", "getRuleSetId$detekt_api", "filters", "Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "getFilters", "()Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "filters$delegate", "Lkotlin/Lazy;", "visitCondition", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "shouldRunOnGivenFile", "computeSeverity", "Lio/gitlab/arturbosch/detekt/api/SeverityLevel;", "report", "", "finding", "Lio/gitlab/arturbosch/detekt/api/Finding;", "findings", "", "detekt-api"})
@SourceDebugExtension(value={"SMAP\nRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rule.kt\nio/gitlab/arturbosch/detekt/api/Rule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1863#2,2:106\n*S KotlinDebug\n*F\n+ 1 Rule.kt\nio/gitlab/arturbosch/detekt/api/Rule\n*L\n90#1:106,2\n*E\n"})
public abstract class Rule
extends BaseRule
implements ConfigAware {
    @NotNull
    private final Config ruleSetConfig;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Lazy filters$delegate;

    public Rule(@NotNull Config ruleSetConfig, @NotNull Context ruleContext) {
        Intrinsics.checkNotNullParameter(ruleSetConfig, "ruleSetConfig");
        Intrinsics.checkNotNullParameter(ruleContext, "ruleContext");
        super(ruleContext);
        this.ruleSetConfig = ruleSetConfig;
        this.defaultRuleIdAliases = SetsKt.emptySet();
        this.filters$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> Rule.filters_delegate$lambda$0(this));
    }

    public /* synthetic */ Rule(Config config, Context context, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n & 2) != 0) {
            context = new DefaultContext();
        }
        this(config, context);
    }

    @Override
    @NotNull
    public Config getRuleSetConfig() {
        return this.ruleSetConfig;
    }

    @NotNull
    public abstract Issue getIssue();

    @Override
    @NotNull
    public final String getRuleId() {
        return this.getIssue().getId();
    }

    @NotNull
    public final Set<String> getAliases() {
        return this.valueOrDefault("aliases", this.getDefaultRuleIdAliases());
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @Nullable
    public final String getRuleSetId$detekt_api() {
        return this.getRuleSetConfig().getParentPath();
    }

    @Nullable
    public PathFilters getFilters() {
        Lazy lazy = this.filters$delegate;
        return (PathFilters)lazy.getValue();
    }

    @Override
    public boolean visitCondition(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter(root, "root");
        return this.getActive() && this.shouldRunOnGivenFile(root) && !SuppressionsKt.isSuppressedBy(root, this.getRuleId(), this.getAliases(), this.getRuleSetId$detekt_api());
    }

    private final boolean shouldRunOnGivenFile(KtFile root) {
        PathFilters pathFilters = this.getFilters();
        return pathFilters != null ? !pathFilters.isIgnored(root) : true;
    }

    private final SeverityLevel computeSeverity() {
        String configValue;
        String string2 = (String)this.valueOrNull("severity");
        if (string2 == null) {
            string2 = this.getRuleSetConfig().valueOrDefault("severity", "warning");
        }
        String string3 = configValue = string2;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue(locale, "US");
        String string4 = string3.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
        return SeverityLevel.valueOf(string4);
    }

    public final void report(@NotNull Finding finding) {
        Intrinsics.checkNotNullParameter(finding, "finding");
        CodeSmell codeSmell = finding instanceof CodeSmell ? (CodeSmell)finding : null;
        if (codeSmell != null) {
            codeSmell.setInternalSeverity$detekt_api(this.computeSeverity());
        }
        this.report(finding, this.getAliases(), this.getRuleSetId$detekt_api());
    }

    public final void report(@NotNull List<? extends Finding> findings) {
        Intrinsics.checkNotNullParameter(findings, "findings");
        Iterable $this$forEach$iv = findings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Finding it = (Finding)element$iv;
            boolean bl = false;
            CodeSmell codeSmell = it instanceof CodeSmell ? (CodeSmell)it : null;
            if (codeSmell == null) continue;
            codeSmell.setInternalSeverity$detekt_api(this.computeSeverity());
        }
        this.report(findings, this.getAliases(), this.getRuleSetId$detekt_api());
    }

    @Override
    public boolean getAutoCorrect() {
        return ConfigAware.DefaultImpls.getAutoCorrect(this);
    }

    @Override
    public boolean getActive() {
        return ConfigAware.DefaultImpls.getActive(this);
    }

    @Override
    public void withAutoCorrect(@NotNull Function0<Unit> block) {
        ConfigAware.DefaultImpls.withAutoCorrect(this, block);
    }

    @Override
    @NotNull
    public Config subConfig(@NotNull String key) {
        return ConfigAware.DefaultImpls.subConfig(this, key);
    }

    @Override
    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        return ConfigAware.DefaultImpls.valueOrDefault(this, key, t);
    }

    @Override
    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        return ConfigAware.DefaultImpls.valueOrNull(this, key);
    }

    @Override
    @Nullable
    public String getParentPath() {
        return ConfigAware.DefaultImpls.getParentPath(this);
    }

    private static final PathFilters filters_delegate$lambda$0(Rule this$0) {
        return PathFiltersKt.createPathFilters(this$0);
    }

    public Rule() {
        this(null, null, 3, null);
    }
}

