/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.tooling.api;

import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004*\u00020\u0001H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"getSignatureParameter", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "splitParams", "", "changeIfLambda", "param", "splitLambda", "Lkotlin/Pair;", "functionSignatureRegex", "Lkotlin/text/Regex;", "detekt-tooling"})
@SourceDebugExtension(value={"SMAP\nFunctionMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionMatcher.kt\nio/github/detekt/tooling/api/FunctionMatcherKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1179#2,2:157\n1863#3,2:159\n*S KotlinDebug\n*F\n+ 1 FunctionMatcher.kt\nio/github/detekt/tooling/api/FunctionMatcherKt\n*L\n100#1:157,2\n138#1:159,2\n*E\n"})
public final class FunctionMatcherKt {
    @NotNull
    private static final Regex functionSignatureRegex = new Regex("((?:[^()`]|`.*`)*)(?:\\((.*)\\))?");

    private static final String getSignatureParameter(KotlinType $this$getSignatureParameter) {
        String string2;
        if (org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.isTypeParameter($this$getSignatureParameter)) {
            string2 = $this$getSignatureParameter.toString();
        } else {
            FqName fqName = TypeUtilsKt.fqNameOrNull($this$getSignatureParameter);
            string2 = fqName != null ? fqName.toString() : null;
        }
        return string2;
    }

    private static final List<String> splitParams(String $this$splitParams) {
        List split = new ArrayList();
        int nestingLevel = 0;
        StringBuilder result2 = new StringBuilder();
        CharSequence $this$forEach$iv = $this$splitParams;
        boolean $i$f$forEach = false;
        for (int j = 0; j < $this$forEach$iv.length(); ++j) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(j);
            boolean bl = false;
            if (c == ',' && nestingLevel == 0) {
                String string2 = result2.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                split.add(((Object)StringsKt.trim((CharSequence)string2)).toString());
                result2.setLength(0);
                continue;
            }
            if (c == '(') {
                ++nestingLevel;
            }
            if (c == ')') {
                nestingLevel += -1;
            }
            if (!(nestingLevel >= 0)) {
                String string3 = "Check failed.";
                throw new IllegalStateException(string3.toString());
            }
            result2.append(c);
        }
        String string4 = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        String lastParam = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        if (((CharSequence)lastParam).length() > 0) {
            split.add(lastParam);
        }
        return split;
    }

    private static final String changeIfLambda(String param2) {
        Pair<String, String> pair = FunctionMatcherKt.splitLambda(param2);
        if (pair == null) {
            return null;
        }
        String paramsRaw = pair.component1();
        List<String> params = FunctionMatcherKt.splitParams(paramsRaw);
        return "kotlin.Function" + ((Collection)params).size();
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<String, String> splitLambda(String param2) {
        void $this$forEach$iv;
        if (!StringsKt.startsWith$default(param2, "(", false, 2, null)) {
            return null;
        }
        int nestingLevel = 0;
        StringBuilder paramsRaw = new StringBuilder();
        StringBuilder returnValue = new StringBuilder();
        char[] cArray = param2.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        Iterable iterable = ArraysKt.drop(cArray, 1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            char c = ((Character)element$iv).charValue();
            boolean bl = false;
            if (nestingLevel >= 0) {
                if (c == '(') {
                    ++nestingLevel;
                }
                if (c == ')') {
                    nestingLevel += -1;
                }
                if (nestingLevel < 0) continue;
                paramsRaw.append(c);
                continue;
            }
            returnValue.append(c);
        }
        if (!StringsKt.startsWith$default(StringsKt.trim(returnValue), (CharSequence)"->", false, 2, null)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        String string3 = paramsRaw.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        String string5 = returnValue.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
        return TuplesKt.to(string4, ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default(string5, "->", null, 2, null))).toString());
    }

    public static final /* synthetic */ String access$getSignatureParameter(KotlinType $receiver) {
        return FunctionMatcherKt.getSignatureParameter($receiver);
    }

    public static final /* synthetic */ Regex access$getFunctionSignatureRegex$p() {
        return functionSignatureRegex;
    }

    public static final /* synthetic */ List access$splitParams(String $receiver) {
        return FunctionMatcherKt.splitParams($receiver);
    }

    public static final /* synthetic */ String access$changeIfLambda(String param2) {
        return FunctionMatcherKt.changeIfLambda(param2);
    }
}

