/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.report.sarif;

import io.github.detekt.sarif4k.ArtifactLocation;
import io.github.detekt.sarif4k.Level;
import io.github.detekt.sarif4k.Message;
import io.github.detekt.sarif4k.PhysicalLocation;
import io.github.detekt.sarif4k.Region;
import io.github.detekt.sarif4k.Result;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.SeverityLevel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.NavigatablePsiElement;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\u0002*\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0002\u001a\u0016\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0011"}, d2={"toResults", "", "Lio/github/detekt/sarif4k/Result;", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "toResultLevel", "Lio/github/detekt/sarif4k/Level;", "Lio/gitlab/arturbosch/detekt/api/SeverityLevel;", "toResult", "Lio/gitlab/arturbosch/detekt/api/Finding;", "ruleSetId", "", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "toLocation", "Lio/github/detekt/sarif4k/Location;", "Lio/gitlab/arturbosch/detekt/api/Location;", "code", "detekt-report-sarif"})
@SourceDebugExtension(value={"SMAP\nResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Results.kt\nio/github/detekt/report/sarif/ResultsKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n77#2:67\n97#2,2:68\n99#2,3:74\n1557#3:70\n1628#3,3:71\n1557#3:77\n1628#3,3:78\n*S KotlinDebug\n*F\n+ 1 Results.kt\nio/github/detekt/report/sarif/ResultsKt\n*L\n16#1:67\n16#1:68,2\n16#1:74,3\n17#1:70\n17#1:71,3\n32#1:77\n32#1:78,3\n*E\n"})
public final class ResultsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Result> toResults(@NotNull Detektion detektion) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(detektion, "detektion");
        Map<String, List<Finding>> $this$flatMap$iv = detektion.getFindings();
        boolean $i$f$flatMap = false;
        Map<String, List<Finding>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            String ruleSetId = (String)entry.getKey();
            List findings = (List)entry.getValue();
            Iterable $this$map$iv = findings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Finding finding = (Finding)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(ResultsKt.toResult((Finding)it, ruleSetId));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Level toResultLevel(@NotNull SeverityLevel $this$toResultLevel) {
        Level level;
        Intrinsics.checkNotNullParameter((Object)$this$toResultLevel, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toResultLevel.ordinal()]) {
            case 1: {
                level = Level.Error;
                break;
            }
            case 2: {
                level = Level.Warning;
                break;
            }
            case 3: {
                level = Level.Note;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return level;
    }

    private static final Result toResult(Finding $this$toResult, String ruleSetId) {
        Location it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        NavigatablePsiElement navigatablePsiElement = $this$toResult.getEntity().getKtElement();
        String code2 = navigatablePsiElement != null && (navigatablePsiElement = navigatablePsiElement.getContainingFile()) != null ? navigatablePsiElement.getText() : null;
        String string2 = "detekt." + ruleSetId + '.' + $this$toResult.getId();
        Level level = ResultsKt.toResultLevel($this$toResult.getSeverity());
        Object object = $this$toResult.getReferences();
        Collection collection = CollectionsKt.listOf($this$toResult.getLocation());
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entity entity = (Entity)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((Entity)((Object)it)).getLocation());
        }
        $this$map$iv = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Location)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ResultsKt.toLocation(it, code2));
        }
        List list = CollectionsKt.toList(CollectionsKt.distinct((List)destination$iv$iv));
        object = new Message(null, null, null, null, $this$toResult.messageOrDescription(), 15, null);
        return new Result(null, null, null, null, null, null, null, null, null, null, null, null, level, list, (Message)object, null, null, null, null, null, null, null, string2, null, null, null, null, null, null, null, 1069518847, null);
    }

    private static final io.github.detekt.sarif4k.Location toLocation(Location $this$toLocation, String code2) {
        ArtifactLocation artifactLocation;
        Long endLine = null;
        Long endColumn = null;
        if (code2 != null) {
            char[] cArray = new char[]{'\n'};
            List snippet = StringsKt.split$default((CharSequence)StringsKt.take(code2, $this$toLocation.getText().getEnd()), cArray, false, 0, 6, null);
            endLine = snippet.size();
            endColumn = (long)((String)CollectionsKt.last(snippet)).length() + 1L;
        }
        long l = $this$toLocation.getSource().getLine();
        long l2 = $this$toLocation.getSource().getColumn();
        Long l3 = endLine;
        Long l4 = endColumn;
        Region region = new Region(null, null, null, null, l4, l3, null, null, null, null, l2, (Long)l, 975, null);
        if ($this$toLocation.getFilePath().getRelativePath() != null) {
            Path path = $this$toLocation.getFilePath().getRelativePath();
            artifactLocation = new ArtifactLocation(null, null, null, path != null ? PathsKt.getInvariantSeparatorsPathString(path) : null, "%SRCROOT%", 7, null);
        } else {
            artifactLocation = new ArtifactLocation(null, null, null, $this$toLocation.getFilePath().getAbsolutePath().toUri().toString(), null, 23, null);
        }
        ArtifactLocation artifactLocation2 = artifactLocation;
        return new io.github.detekt.sarif4k.Location(null, null, null, null, new PhysicalLocation(null, artifactLocation2, null, null, region, 13, null), null, null, 111, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SeverityLevel.values().length];
            try {
                nArray[SeverityLevel.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SeverityLevel.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SeverityLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

