/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.psi;

import io.github.detekt.psi.FilePath;
import io.github.detekt.psi.KeysKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0006\u001a\f\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u0006\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\u0006\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0006\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\fH\u0007\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"KOTLIN_SUFFIX", "", "KOTLIN_SCRIPT_SUFFIX", "KOTLIN_GENERIC_SUFFIXES", "", "fileName", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "getFileName", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;)Ljava/lang/String;", "fileNameWithoutSuffix", "multiplatformTargetSuffixes", "absolutePath", "Ljava/nio/file/Path;", "relativePath", "basePath", "toFilePath", "Lio/github/detekt/psi/FilePath;", "getLineAndColumnInPsiFile", "Lorg/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils$LineAndColumn;", "file", "range", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "toUnifiedString", "buildPlatformSpecificSuffixes", "platforms", "detekt-psi-utils"})
@SourceDebugExtension(value={"SMAP\nKtFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFiles.kt\nio/github/detekt/psi/KtFilesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n1557#3:109\n1628#3,3:110\n*S KotlinDebug\n*F\n+ 1 KtFiles.kt\nio/github/detekt/psi/KtFilesKt\n*L\n106#1:109\n106#1:110,3\n*E\n"})
public final class KtFilesKt {
    @NotNull
    public static final String KOTLIN_SUFFIX = ".kt";
    @NotNull
    public static final String KOTLIN_SCRIPT_SUFFIX = ".kts";
    @NotNull
    private static final List<String> KOTLIN_GENERIC_SUFFIXES;

    @NotNull
    public static final String getFileName(@NotNull PsiFile $this$fileName) {
        Intrinsics.checkNotNullParameter($this$fileName, "<this>");
        String string2 = $this$fileName.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        return StringsKt.substringAfterLast$default(string2, File.separatorChar, null, 2, null);
    }

    @NotNull
    public static final String fileNameWithoutSuffix(@NotNull PsiFile $this$fileNameWithoutSuffix, @NotNull List<String> multiplatformTargetSuffixes) {
        Intrinsics.checkNotNullParameter($this$fileNameWithoutSuffix, "<this>");
        Intrinsics.checkNotNullParameter(multiplatformTargetSuffixes, "multiplatformTargetSuffixes");
        String fileName = KtFilesKt.getFileName($this$fileNameWithoutSuffix);
        List<String> suffixesToRemove = CollectionsKt.plus((Collection)KtFilesKt.buildPlatformSpecificSuffixes(multiplatformTargetSuffixes), (Iterable)KOTLIN_GENERIC_SUFFIXES);
        for (String suffix : suffixesToRemove) {
            if (!StringsKt.endsWith$default(fileName, suffix, false, 2, null)) continue;
            return StringsKt.removeSuffix(fileName, (CharSequence)suffix);
        }
        return fileName;
    }

    public static /* synthetic */ String fileNameWithoutSuffix$default(PsiFile psiFile, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return KtFilesKt.fileNameWithoutSuffix(psiFile, list);
    }

    @NotNull
    public static final Path absolutePath(@NotNull PsiFile $this$absolutePath) {
        Intrinsics.checkNotNullParameter($this$absolutePath, "<this>");
        String string2 = $this$absolutePath.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        Path path = Paths.get(string2, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        return path;
    }

    @Nullable
    public static final Path relativePath(@NotNull PsiFile $this$relativePath) {
        Path path;
        Intrinsics.checkNotNullParameter($this$relativePath, "<this>");
        String string2 = $this$relativePath.getUserData(KeysKt.getRELATIVE_PATH());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            Path path2 = Paths.get(it, new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public static final Path basePath(@NotNull PsiFile $this$basePath) {
        Path path;
        Intrinsics.checkNotNullParameter($this$basePath, "<this>");
        String string2 = $this$basePath.getUserData(KeysKt.getBASE_PATH());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            Path path2 = Paths.get(it, new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        } else {
            path = null;
        }
        return path;
    }

    @NotNull
    public static final FilePath toFilePath(@NotNull PsiFile $this$toFilePath) {
        FilePath filePath;
        Intrinsics.checkNotNullParameter($this$toFilePath, "<this>");
        Path relativePath = KtFilesKt.relativePath($this$toFilePath);
        Path basePath = KtFilesKt.basePath($this$toFilePath);
        if (basePath != null && relativePath != null) {
            filePath = new FilePath(KtFilesKt.absolutePath($this$toFilePath), basePath, relativePath);
        } else if (basePath == null && relativePath == null) {
            filePath = new FilePath(KtFilesKt.absolutePath($this$toFilePath), null, null, 6, null);
        } else {
            throw new IllegalStateException(("Cannot build a FilePath from base path = " + basePath + " and relative path = " + relativePath).toString());
        }
        return filePath;
    }

    @Nullable
    public static final PsiDiagnosticUtils.LineAndColumn getLineAndColumnInPsiFile(@NotNull PsiFile file2, @NotNull TextRange range) {
        PsiDiagnosticUtils.LineAndColumn lineAndColumn;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(range, "range");
        if (file2.getTextLength() == 0) {
            lineAndColumn = null;
        } else {
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl(DiagnosticUtils.getLineAndColumnInPsiFile(file2, range));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            lineAndColumn = (PsiDiagnosticUtils.LineAndColumn)(Result.isFailure-impl(object) ? null : object);
        }
        return lineAndColumn;
    }

    @Deprecated(message="Use stdlib method", replaceWith=@ReplaceWith(expression="invariantSeparatorsPathString", imports={"kotlin.io.path.invariantSeparatorsPathString"}))
    @NotNull
    public static final String toUnifiedString(@NotNull Path $this$toUnifiedString) {
        Intrinsics.checkNotNullParameter($this$toUnifiedString, "<this>");
        return PathsKt.getInvariantSeparatorsPathString($this$toUnifiedString);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> buildPlatformSpecificSuffixes(List<String> platforms) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = platforms;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void platform;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add('.' + (String)platform + KOTLIN_SUFFIX);
        }
        return (List)destination$iv$iv;
    }

    static {
        String[] stringArray = new String[]{KOTLIN_SUFFIX, KOTLIN_SCRIPT_SUFFIX};
        KOTLIN_GENERIC_SUFFIXES = CollectionsKt.listOf(stringArray);
    }
}

