/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.metrics;

import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020#H\u0016J\f\u0010$\u001a\u00020\u0010*\u00020%H\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lio/github/detekt/metrics/CyclomaticComplexity;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "config", "Lio/github/detekt/metrics/CyclomaticComplexity$Config;", "<init>", "(Lio/github/detekt/metrics/CyclomaticComplexity$Config;)V", "value", "", "complexity", "getComplexity", "()I", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isInsideObjectLiteral", "", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "extractEntries", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "isUsedForNesting", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallExpression", "Config", "Companion", "detekt-metrics"})
@SourceDebugExtension(value={"SMAP\nCyclomaticComplexity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CyclomaticComplexity.kt\nio/github/detekt/metrics/CyclomaticComplexity\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,128:1\n142#2:129\n*S KotlinDebug\n*F\n+ 1 CyclomaticComplexity.kt\nio/github/detekt/metrics/CyclomaticComplexity\n*L\n44#1:129\n*E\n"})
public final class CyclomaticComplexity
extends DetektVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    private int complexity;
    @NotNull
    private static final Set<KtSingleValueToken> CONDITIONALS;
    @NotNull
    private static final Set<String> DEFAULT_NESTING_FUNCTIONS;

    public CyclomaticComplexity(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.config = config;
    }

    public final int getComplexity() {
        return this.complexity;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (!this.isInsideObjectLiteral(function2)) {
            int n = this.complexity;
            this.complexity = n + 1;
            super.visitNamedFunction(function2);
        }
    }

    private final boolean isInsideObjectLiteral(KtNamedFunction function2) {
        PsiElement $this$getStrictParentOfType$iv = function2;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtObjectLiteralExpression.class, true) != null;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (CollectionsKt.contains((Iterable)CONDITIONALS, expression2.getOperationToken())) {
            int n = this.complexity;
            this.complexity = n + 1;
        }
        super.visitBinaryExpression(expression2);
    }

    @Override
    public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitContinueExpression(expression2);
    }

    @Override
    public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitBreakExpression(expression2);
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitIfExpression(expression2);
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        int n = this.complexity;
        this.complexity = n + 1;
        super.visitLoopExpression(loopExpression);
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Sequence<KtWhenEntry> entries2 = this.extractEntries(expression2);
        this.complexity += this.config.getIgnoreSimpleWhenEntries() && SequencesKt.count(entries2) == 0 ? 1 : SequencesKt.count(entries2);
        super.visitWhenExpression(expression2);
    }

    private final Sequence<KtWhenEntry> extractEntries(KtWhenExpression $this$extractEntries) {
        List<KtWhenEntry> list = $this$extractEntries.getEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
        Sequence<KtWhenEntry> entries2 = CollectionsKt.asSequence((Iterable)list);
        return this.config.getIgnoreSimpleWhenEntries() ? SequencesKt.filter(entries2, CyclomaticComplexity::extractEntries$lambda$0) : entries2;
    }

    @Override
    public void visitTryExpression(@NotNull KtTryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.complexity += expression2.getCatchClauses().size();
        super.visitTryExpression(expression2);
    }

    private final boolean isUsedForNesting(KtCallExpression $this$isUsedForNesting) {
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression($this$isUsedForNesting);
        String string2 = ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null;
        return CollectionsKt.contains((Iterable)this.config.getNestingFunctions(), string2);
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.config.getIgnoreNestingFunctions() && this.isUsedForNesting(expression2)) {
            KtLambdaExpression lambdaExpression;
            List<KtLambdaArgument> list = expression2.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getLambdaArguments(...)");
            KtLambdaArgument ktLambdaArgument = CollectionsKt.firstOrNull(list);
            KtLambdaExpression ktLambdaExpression = lambdaExpression = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
            if ((ktLambdaExpression != null ? ktLambdaExpression.getBodyExpression() : null) != null) {
                int n = this.complexity;
                this.complexity = n + 1;
            }
        }
        super.visitCallExpression(expression2);
    }

    private static final boolean extractEntries$lambda$0(KtWhenEntry it) {
        return it.getExpression() instanceof KtBlockExpression;
    }

    static {
        Object[] objectArray = new KtSingleValueToken[]{KtTokens.ELVIS, KtTokens.ANDAND, KtTokens.OROR};
        CONDITIONALS = SetsKt.setOf(objectArray);
        objectArray = new String[]{"run", "let", "apply", "with", "also", "use", "forEach", "isNotNull", "ifNull"};
        DEFAULT_NESTING_FUNCTIONS = SetsKt.setOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001b\b\u0002\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0015R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0016"}, d2={"Lio/github/detekt/metrics/CyclomaticComplexity$Companion;", "", "<init>", "()V", "CONDITIONALS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "getCONDITIONALS", "()Ljava/util/Set;", "DEFAULT_NESTING_FUNCTIONS", "", "getDEFAULT_NESTING_FUNCTIONS", "calculate", "", "node", "Lorg/jetbrains/kotlin/psi/KtElement;", "configure", "Lkotlin/Function1;", "Lio/github/detekt/metrics/CyclomaticComplexity$Config;", "", "Lkotlin/ExtensionFunctionType;", "detekt-metrics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<KtSingleValueToken> getCONDITIONALS() {
            return CONDITIONALS;
        }

        @NotNull
        public final Set<String> getDEFAULT_NESTING_FUNCTIONS() {
            return DEFAULT_NESTING_FUNCTIONS;
        }

        public final int calculate(@NotNull KtElement node, @Nullable Function1<? super Config, Unit> configure) {
            Intrinsics.checkNotNullParameter(node, "node");
            Config config = new Config(false, false, null, 7, null);
            Function1<? super Config, Unit> function1 = configure;
            if (function1 != null) {
                function1.invoke(config);
            }
            CyclomaticComplexity visitor2 = new CyclomaticComplexity(config);
            node.accept(visitor2);
            return visitor2.getComplexity();
        }

        public static /* synthetic */ int calculate$default(Companion companion, KtElement ktElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = null;
            }
            return companion.calculate(ktElement, function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/github/detekt/metrics/CyclomaticComplexity$Config;", "", "ignoreSimpleWhenEntries", "", "ignoreNestingFunctions", "nestingFunctions", "", "", "<init>", "(ZZLjava/util/Set;)V", "getIgnoreSimpleWhenEntries", "()Z", "setIgnoreSimpleWhenEntries", "(Z)V", "getIgnoreNestingFunctions", "setIgnoreNestingFunctions", "getNestingFunctions", "()Ljava/util/Set;", "setNestingFunctions", "(Ljava/util/Set;)V", "detekt-metrics"})
    public static final class Config {
        private boolean ignoreSimpleWhenEntries;
        private boolean ignoreNestingFunctions;
        @NotNull
        private Set<String> nestingFunctions;

        public Config(boolean ignoreSimpleWhenEntries, boolean ignoreNestingFunctions, @NotNull Set<String> nestingFunctions) {
            Intrinsics.checkNotNullParameter(nestingFunctions, "nestingFunctions");
            this.ignoreSimpleWhenEntries = ignoreSimpleWhenEntries;
            this.ignoreNestingFunctions = ignoreNestingFunctions;
            this.nestingFunctions = nestingFunctions;
        }

        public /* synthetic */ Config(boolean bl, boolean bl2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                set = Companion.getDEFAULT_NESTING_FUNCTIONS();
            }
            this(bl, bl2, set);
        }

        public final boolean getIgnoreSimpleWhenEntries() {
            return this.ignoreSimpleWhenEntries;
        }

        public final void setIgnoreSimpleWhenEntries(boolean bl) {
            this.ignoreSimpleWhenEntries = bl;
        }

        public final boolean getIgnoreNestingFunctions() {
            return this.ignoreNestingFunctions;
        }

        public final void setIgnoreNestingFunctions(boolean bl) {
            this.ignoreNestingFunctions = bl;
        }

        @NotNull
        public final Set<String> getNestingFunctions() {
            return this.nestingFunctions;
        }

        public final void setNestingFunctions(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, "<set-?>");
            this.nestingFunctions = set;
        }

        public Config() {
            this(false, false, null, 7, null);
        }
    }
}

