/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFloatIterator;
import gnu.trove.TDoubleFloatProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TDoubleFloatHashMap
extends TDoubleHash {
    protected transient float[] _values;

    public TDoubleFloatHashMap() {
    }

    public TDoubleFloatHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TDoubleFloatHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TDoubleFloatHashMap(TDoubleHashingStrategy strategy) {
        super(strategy);
    }

    public TDoubleFloatHashMap(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TDoubleFloatHashMap(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TDoubleFloatHashMap m = (TDoubleFloatHashMap)super.clone();
        m._values = this._values == null ? null : (float[])this._values.clone();
        return m;
    }

    public TDoubleFloatIterator iterator() {
        return new TDoubleFloatIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new float[capacity];
        return capacity;
    }

    public float put(double key, float value2) {
        float previous = 0.0f;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value2;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        double[] oldKeys = this._set;
        float[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new double[newCapacity];
        this._values = new float[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            double o = oldKeys[i2];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i2];
            this._states[index] = 1;
        }
    }

    public float get(double key) {
        int index = this.index(key);
        return index < 0 ? 0.0f : this._values[index];
    }

    public void clear() {
        super.clear();
        double[] keys2 = this._set;
        float[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i2 = keys2.length;
        while (i2-- > 0) {
            keys2[i2] = 0.0;
            vals[i2] = 0.0f;
            states[i2] = 0;
        }
    }

    public float remove(double key) {
        float prev = 0.0f;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleFloatHashMap)) {
            return false;
        }
        TDoubleFloatHashMap that = (TDoubleFloatHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p2 = new HashProcedure();
        this.forEachEntry(p2);
        return p2.getHashCode();
    }

    protected void removeAt(int index) {
        this._values[index] = 0.0f;
        super.removeAt(index);
    }

    public float[] getValues() {
        float[] vals = new float[this.size()];
        float[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                vals[j++] = v[i2];
            }
        }
        return vals;
    }

    public double[] keys() {
        double[] keys2 = new double[this.size()];
        double[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                keys2[j++] = k[i2];
            }
        }
        return keys2;
    }

    public boolean containsValue(float val) {
        byte[] states = this._states;
        float[] vals = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || val != vals[i2]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(double key) {
        return this.contains(key);
    }

    public boolean forEachKey(TDoubleProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TFloatProcedure procedure) {
        byte[] states = this._states;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TDoubleFloatProcedure procedure) {
        byte[] states = this._states;
        double[] keys2 = this._set;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TDoubleFloatProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        double[] keys2 = this._set;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TFloatFunction function2) {
        byte[] states = this._states;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                values2[i2] = function2.execute(values2[i2]);
            }
        }
    }

    public boolean increment(double key) {
        return this.adjustValue(key, 1.0f);
    }

    public boolean adjustValue(double key, float amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            double key = stream.readDouble();
            float val = stream.readFloat();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TDoubleFloatProcedure(){

            public boolean execute(double key, float value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value2);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TDoubleFloatProcedure {
        private final TDoubleFloatHashMap _otherMap;

        EqProcedure(TDoubleFloatHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(double key, float value2) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value2, this._otherMap.get(key));
        }

        private static boolean eq(float v1, float v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TDoubleFloatProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double key, float value2) {
            this.h += TDoubleFloatHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

