/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WrappedParameter {
    private Parameter parameter;
    private DynamicParameter dynamicParameter;

    public WrappedParameter(Parameter p2) {
        this.parameter = p2;
    }

    public WrappedParameter(DynamicParameter p2) {
        this.dynamicParameter = p2;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public DynamicParameter getDynamicParameter() {
        return this.dynamicParameter;
    }

    public int arity() {
        return this.parameter != null ? this.parameter.arity() : 1;
    }

    public boolean hidden() {
        return this.parameter != null ? this.parameter.hidden() : this.dynamicParameter.hidden();
    }

    public boolean required() {
        return this.parameter != null ? this.parameter.required() : this.dynamicParameter.required();
    }

    public boolean password() {
        return this.parameter != null ? this.parameter.password() : false;
    }

    public String[] names() {
        return this.parameter != null ? this.parameter.names() : this.dynamicParameter.names();
    }

    public boolean variableArity() {
        return this.parameter != null ? this.parameter.variableArity() : false;
    }

    public int order() {
        return this.parameter != null ? this.parameter.order() : this.dynamicParameter.order();
    }

    public String category() {
        return this.parameter != null ? this.parameter.category() : this.dynamicParameter.category();
    }

    public Class<? extends IParameterValidator>[] validateWith() {
        return this.parameter != null ? this.parameter.validateWith() : this.dynamicParameter.validateWith();
    }

    public Class<? extends IValueValidator>[] validateValueWith() {
        return this.parameter != null ? this.parameter.validateValueWith() : this.dynamicParameter.validateValueWith();
    }

    public boolean echoInput() {
        return this.parameter != null ? this.parameter.echoInput() : false;
    }

    public void addValue(Parameterized parameterized, Object object, Object value2) {
        try {
            this.addValue(parameterized, object, value2, null);
        }
        catch (IllegalAccessException e) {
            throw new ParameterException("Couldn't set " + object + " to " + value2, e);
        }
    }

    public void addValue(Parameterized parameterized, Object object, Object value2, Field field) throws IllegalAccessException {
        if (this.parameter != null) {
            if (field != null) {
                field.set(object, value2);
            } else {
                parameterized.set(object, value2);
            }
        } else {
            String a2 = this.dynamicParameter.assignment();
            String sv = value2.toString();
            int aInd = sv.indexOf(a2);
            if (aInd == -1) {
                throw new ParameterException("Dynamic parameter expected a value of the form a" + a2 + "b but got:" + sv);
            }
            this.callPut(object, parameterized, sv.substring(0, aInd), sv.substring(aInd + 1));
        }
    }

    private void callPut(Object object, Parameterized parameterized, String key, String value2) {
        try {
            Method m = this.findPut(parameterized.getType());
            m.invoke(parameterized.get(object), key, value2);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Method findPut(Class<?> cls) throws SecurityException, NoSuchMethodException {
        return cls.getMethod("put", Object.class, Object.class);
    }

    public String getAssignment() {
        return this.dynamicParameter != null ? this.dynamicParameter.assignment() : "";
    }

    public boolean isHelp() {
        return this.parameter != null && this.parameter.help();
    }

    public boolean isNonOverwritableForced() {
        return this.parameter != null && this.parameter.forceNonOverwritable();
    }
}

