/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IParameterValidator2;
import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ResourceBundle;
import com.beust.jcommander.Strings;
import com.beust.jcommander.SubParameter;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.validators.NoValidator;
import com.beust.jcommander.validators.NoValueValidator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ParameterDescription {
    private Object object;
    private WrappedParameter wrappedParameter;
    private Parameter parameterAnnotation;
    private DynamicParameter dynamicParameterAnnotation;
    private Parameterized parameterized;
    private boolean assigned = false;
    private java.util.ResourceBundle bundle;
    private String description;
    private JCommander jCommander;
    private Object defaultObject;
    private String longestName = "";
    private Object value;

    public ParameterDescription(Object object, DynamicParameter annotation, Parameterized parameterized, java.util.ResourceBundle bundle, JCommander jc) {
        if (!Map.class.isAssignableFrom(parameterized.getType())) {
            throw new ParameterException("@DynamicParameter " + parameterized.getName() + " should be of type Map but is " + parameterized.getType().getName());
        }
        this.dynamicParameterAnnotation = annotation;
        this.wrappedParameter = new WrappedParameter(this.dynamicParameterAnnotation);
        this.init(object, parameterized, bundle, jc);
    }

    public ParameterDescription(Object object, Parameter annotation, Parameterized parameterized, java.util.ResourceBundle bundle, JCommander jc) {
        this.parameterAnnotation = annotation;
        this.wrappedParameter = new WrappedParameter(this.parameterAnnotation);
        this.init(object, parameterized, bundle, jc);
    }

    private java.util.ResourceBundle findResourceBundle(Object o) {
        java.util.ResourceBundle result2 = null;
        Parameters p2 = o.getClass().getAnnotation(Parameters.class);
        if (p2 != null && !Strings.isStringEmpty(p2.resourceBundle())) {
            result2 = java.util.ResourceBundle.getBundle(p2.resourceBundle(), Locale.getDefault());
        } else {
            ResourceBundle a2 = o.getClass().getAnnotation(ResourceBundle.class);
            if (a2 != null && !Strings.isStringEmpty(a2.value())) {
                result2 = java.util.ResourceBundle.getBundle(a2.value(), Locale.getDefault());
            }
        }
        return result2;
    }

    private void initDescription(String description, String descriptionKey, String[] names) {
        this.description = description;
        if (!Strings.isStringEmpty(descriptionKey) && this.bundle != null) {
            this.description = this.bundle.getString(descriptionKey);
        }
        for (String name2 : names) {
            if (name2.length() <= this.longestName.length()) continue;
            this.longestName = name2;
        }
    }

    private void init(Object object, Parameterized parameterized, java.util.ResourceBundle bundle, JCommander jCommander) {
        this.object = object;
        this.parameterized = parameterized;
        this.bundle = bundle;
        if (this.bundle == null) {
            this.bundle = this.findResourceBundle(object);
        }
        this.jCommander = jCommander;
        if (this.parameterAnnotation != null) {
            String description = Enum.class.isAssignableFrom(parameterized.getType()) && this.parameterAnnotation.description().isEmpty() ? "Options: " + EnumSet.allOf(parameterized.getType()) : this.parameterAnnotation.description();
            this.initDescription(description, this.parameterAnnotation.descriptionKey(), this.parameterAnnotation.names());
        } else if (this.dynamicParameterAnnotation != null) {
            this.initDescription(this.dynamicParameterAnnotation.description(), this.dynamicParameterAnnotation.descriptionKey(), this.dynamicParameterAnnotation.names());
        } else {
            throw new AssertionError((Object)"Shound never happen");
        }
        try {
            this.defaultObject = parameterized.get(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.defaultObject != null && this.parameterAnnotation != null && !this.parameterAnnotation.required()) {
            this.validateDefaultValues(this.parameterAnnotation.names());
        }
    }

    private void validateDefaultValues(String[] names) {
        String name2 = names.length > 0 ? names[0] : "";
        this.validateValueParameter(name2, this.defaultObject);
    }

    public String getLongestName() {
        return this.longestName;
    }

    public Object getDefault() {
        return this.defaultObject;
    }

    public Object getDefaultValueDescription() {
        return this.parameterAnnotation == null ? this.defaultObject : (this.parameterAnnotation.defaultValueDescription().isEmpty() ? this.defaultObject : this.parameterAnnotation.defaultValueDescription());
    }

    public String getDescription() {
        return this.description;
    }

    public Object getObject() {
        return this.object;
    }

    public String getNames() {
        StringBuilder sb = new StringBuilder();
        String[] names = this.wrappedParameter.names();
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(names[i2]);
        }
        return sb.toString();
    }

    public String getCategory() {
        return this.wrappedParameter.category();
    }

    public WrappedParameter getParameter() {
        return this.wrappedParameter;
    }

    public Parameterized getParameterized() {
        return this.parameterized;
    }

    private boolean isMultiOption() {
        Class<?> fieldType = this.parameterized.getType();
        return fieldType.equals(List.class) || fieldType.equals(Set.class) || this.parameterized.isDynamicParameter();
    }

    public void addValue(String value2) {
        this.addValue(value2, false);
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public void setAssigned(boolean b2) {
        this.assigned = b2;
    }

    public void addValue(String value2, boolean isDefault) {
        this.addValue(null, value2, isDefault, true, -1);
    }

    Object addValue(String name2, String value2, boolean isDefault, boolean validate2, int currentIndex) {
        Collection<Object> finalValue;
        boolean isCollection;
        this.p("Adding " + (isDefault ? "default " : "") + "value:" + value2 + " to parameter:" + this.parameterized.getName());
        if (name2 == null) {
            name2 = this.wrappedParameter.names()[0];
        }
        if (currentIndex == 0 && this.assigned && !this.isMultiOption() && !this.jCommander.isParameterOverwritingAllowed() || this.isNonOverwritableForced()) {
            throw new ParameterException("Can only specify option " + name2 + " once.");
        }
        if (validate2) {
            this.validateParameter(name2, value2);
        }
        Class<?> type2 = this.parameterized.getType();
        Object convertedValue = this.jCommander.convertValue(this.getParameterized(), this.getParameterized().getType(), name2, value2);
        if (validate2) {
            this.validateValueParameter(name2, convertedValue);
        }
        if (isCollection = Collection.class.isAssignableFrom(type2)) {
            Collection<Object> l = (Collection<Object>)this.parameterized.get(this.object);
            if (l == null || this.fieldIsSetForTheFirstTime(isDefault)) {
                l = this.newCollection(type2);
                this.parameterized.set(this.object, l);
            }
            if (convertedValue instanceof Collection) {
                l.addAll((Collection)convertedValue);
            } else {
                l.add(convertedValue);
            }
            finalValue = l;
        } else {
            List<SubParameterIndex> subParameters = this.findSubParameters(type2);
            if (!subParameters.isEmpty()) {
                finalValue = this.handleSubParameters(value2, currentIndex, type2, subParameters);
            } else {
                this.wrappedParameter.addValue(this.parameterized, this.object, convertedValue);
                finalValue = convertedValue;
            }
        }
        if (!isDefault) {
            this.assigned = true;
        }
        this.value = finalValue;
        return finalValue;
    }

    Object getValue() {
        return this.value;
    }

    private Object handleSubParameters(String value2, int currentIndex, Class<?> type2, List<SubParameterIndex> subParameters) {
        Object finalValue;
        SubParameterIndex sai = null;
        for (SubParameterIndex si : subParameters) {
            if (si.order != currentIndex) continue;
            sai = si;
            break;
        }
        if (sai != null) {
            Object objectValue = this.parameterized.get(this.object);
            try {
                if (objectValue == null) {
                    objectValue = type2.newInstance();
                    this.parameterized.set(this.object, objectValue);
                }
                this.wrappedParameter.addValue(this.parameterized, objectValue, value2, sai.field);
                finalValue = objectValue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ParameterException("Couldn't instantiate " + type2, e);
            }
        } else {
            throw new ParameterException("Couldn't find where to assign parameter " + value2 + " in " + type2);
        }
        return finalValue;
    }

    public Parameter getParameterAnnotation() {
        return this.parameterAnnotation;
    }

    private List<SubParameterIndex> findSubParameters(Class<?> type2) {
        ArrayList<SubParameterIndex> result2 = new ArrayList<SubParameterIndex>();
        for (Field field : type2.getDeclaredFields()) {
            SubParameter subParameter = field.getAnnotation(SubParameter.class);
            if (subParameter == null) continue;
            SubParameter sa = subParameter;
            result2.add(new SubParameterIndex(sa.order(), field));
        }
        return result2;
    }

    private void validateParameter(String name2, String value2) {
        Class<? extends IParameterValidator>[] validators = this.wrappedParameter.validateWith();
        if (validators != null && validators.length > 0) {
            for (Class<? extends IParameterValidator> validator2 : validators) {
                this.validateParameter(validator2, name2, value2);
            }
        }
    }

    void validateValueParameter(String name2, Object value2) {
        Class<? extends IValueValidator>[] validators = this.wrappedParameter.validateValueWith();
        if (validators != null && validators.length > 0) {
            for (Class<? extends IValueValidator> validator2 : validators) {
                this.validateValueParameter(validator2, name2, value2);
            }
        }
    }

    public void validateValueParameter(Class<? extends IValueValidator> validator2, String name2, Object value2) {
        try {
            if (validator2 != NoValueValidator.class) {
                this.p("Validating value parameter:" + name2 + " value:" + value2 + " validator:" + validator2);
            }
            validator2.newInstance().validate(name2, value2);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ParameterException("Can't instantiate validator:" + e);
        }
    }

    public void validateParameter(Class<? extends IParameterValidator> validator2, String name2, String value2) {
        try {
            if (validator2 != NoValidator.class) {
                this.p("Validating parameter:" + name2 + " value:" + value2 + " validator:" + validator2);
            }
            validator2.newInstance().validate(name2, value2);
            if (IParameterValidator2.class.isAssignableFrom(validator2)) {
                IParameterValidator2 instance2 = (IParameterValidator2)validator2.newInstance();
                instance2.validate(name2, value2, this);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ParameterException("Can't instantiate validator:" + e);
        }
        catch (ParameterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ParameterException(ex);
        }
    }

    private Collection<Object> newCollection(Class<?> type2) {
        if (SortedSet.class.isAssignableFrom(type2)) {
            return new TreeSet<Object>();
        }
        if (LinkedHashSet.class.isAssignableFrom(type2)) {
            return new LinkedHashSet<Object>();
        }
        if (Set.class.isAssignableFrom(type2)) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(type2)) {
            return new ArrayList<Object>();
        }
        throw new ParameterException("Parameters of Collection type '" + type2.getSimpleName() + "' are not supported. Please use List or Set instead.");
    }

    private boolean fieldIsSetForTheFirstTime(boolean isDefault) {
        return !isDefault && !this.assigned;
    }

    private void p(String string2) {
        if (System.getProperty("jcommander.debug") != null) {
            this.jCommander.getConsole().println("[ParameterDescription] " + string2);
        }
    }

    public String toString() {
        return "[ParameterDescription " + this.parameterized.getName() + "]";
    }

    public boolean isDynamicParameter() {
        return this.dynamicParameterAnnotation != null;
    }

    public boolean isHelp() {
        return this.wrappedParameter.isHelp();
    }

    public boolean isNonOverwritableForced() {
        return this.wrappedParameter.isNonOverwritableForced();
    }

    class SubParameterIndex {
        int order = -1;
        Field field;

        public SubParameterIndex(int order, Field field) {
            this.order = order;
            this.field = field;
        }
    }
}

