/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPProject;

public enum RMProjectType {
    GLOBAL("g"),
    SHARED("s"),
    USER("u");

    private final String prefix;

    private RMProjectType(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static RMProjectType getByPrefix(@NotNull String prefix) {
        RMProjectType[] rMProjectTypeArray = RMProjectType.values();
        int n = rMProjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RMProjectType value = rMProjectTypeArray[n2];
            if (value.getPrefix().equals(prefix)) {
                return value;
            }
            ++n2;
        }
        return USER;
    }

    public static String getPlainProjectId(DBPProject project) {
        char typeC;
        String id = project.getId();
        if (id.length() > 2 && id.charAt(1) == '_' && ((typeC = id.charAt(0)) == 'g' || typeC == 's' || typeC == 'u')) {
            return id.substring(2);
        }
        return id;
    }
}

