/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.OffsetKeyedTreeMap;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionProblemInfo;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLTokenEntryAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;

public class SQLDocumentScriptItemSyntaxContext {
    private static final Log log = Log.getLog(SQLDocumentScriptItemSyntaxContext.class);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final OffsetKeyedTreeMap<SQLQuerySymbolEntry> entries = new OffsetKeyedTreeMap();
    @NotNull
    private final String originalText;
    @NotNull
    private final SQLQueryModel queryModel;
    private final int initialPosition;
    private int length;
    private boolean hasContextBoundaryAtLength = true;
    private boolean isDirty = false;
    @Nullable
    private List<SQLQueryRecognitionProblemInfo> problems = null;

    public SQLDocumentScriptItemSyntaxContext(int initialPosition, @NotNull String originalText, @NotNull SQLQueryModel queryModel, int length) {
        this.initialPosition = initialPosition;
        this.originalText = originalText;
        this.queryModel = queryModel;
        this.length = length;
    }

    public int getInitialPosition() {
        return this.initialPosition;
    }

    @NotNull
    public String getOriginalText() {
        return this.originalText;
    }

    @NotNull
    public SQLQueryModel getQueryModel() {
        return this.queryModel;
    }

    public int length() {
        return this.length;
    }

    public boolean hasContextBoundaryAtLength() {
        return this.hasContextBoundaryAtLength;
    }

    public void setHasContextBoundaryAtLength(boolean hasContextBoundaryAtLength) {
        this.hasContextBoundaryAtLength = hasContextBoundaryAtLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            return this.isDirty;
        }
    }

    public void setProblems(@Nullable List<SQLQueryRecognitionProblemInfo> problems) {
        this.problems = problems;
    }

    @Nullable
    public List<SQLQueryRecognitionProblemInfo> getProblems() {
        return this.problems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SQLTokenEntryAtOffset findToken(int offset) {
        Object object = this.lock;
        synchronized (object) {
            OffsetKeyedTreeMap.NodesIterator<SQLQuerySymbolEntry> it = this.entries.nodesIteratorAt(offset);
            SQLQuerySymbolEntry entry = it.getCurrValue();
            int entryOffset = it.getCurrOffset();
            if (entry == null && it.prev()) {
                entry = it.getCurrValue();
                entryOffset = it.getCurrOffset();
            }
            if (entry != null && entryOffset <= offset && entryOffset + entry.getInterval().length() > offset) {
                return new SQLTokenEntryAtOffset(entryOffset, entry);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerToken(int offset, @NotNull SQLQuerySymbolEntry token) {
        Object object = this.lock;
        synchronized (object) {
            this.entries.put(offset, token);
            this.isDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDelta(int offset, int oldLength, int newLength) {
        Object object = this.lock;
        synchronized (object) {
            if (oldLength > 0) {
                throw new UnsupportedOperationException();
            }
            this.entries.applyOffset(offset, newLength);
            this.length += newLength - oldLength;
            this.isDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCompleted() {
        Object object = this.lock;
        synchronized (object) {
            this.isDirty = false;
        }
    }
}

