/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSDictionaryAccessor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetThemeSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.editors.data.DatabaseDataEditor;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.ReaderWriterLock;

public class ReferenceValueEditor {
    private static final Log log = Log.getLog(ReferenceValueEditor.class);
    private final IResultSetController rsController;
    private final IValueController valueController;
    private IValueEditor valueEditor;
    private DBSEntityReferrer refConstraint;
    private Table editorSelector;
    private Text valueFilterText;
    private static volatile boolean sortByValue = true;
    private static volatile boolean sortAsc = true;
    private TableColumn prevSortColumn = null;
    private LoadingJob<EnumValuesData> dictFilterJob;
    private final ViewController controller;
    private final Action actionGoBackward = new Action("Move Backward", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_LEFT)){

        public void run() {
            ReferenceValueEditor.this.controller.goToPrevPage();
        }
    };
    private final Action actionGoForward = new Action("Move Forward", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_RIGHT)){

        public void run() {
            ReferenceValueEditor.this.controller.goToNextPage();
        }
    };

    public ReferenceValueEditor(@Nullable IResultSetController rsController, IValueController valueController, IValueEditor valueEditor) {
        this.rsController = rsController;
        this.valueController = valueController;
        this.valueEditor = valueEditor;
        DBCExecutionContext executionContext = valueController.getExecutionContext();
        int pageSize = executionContext == null ? 200 : executionContext.getDataSource().getContainer().getPreferenceStore().getInt("dictionary.max.rows");
        this.controller = new ViewController(pageSize);
    }

    public void setValueEditor(IValueEditor valueEditor) {
        this.valueEditor = valueEditor;
    }

    public boolean isReferenceValue() {
        return this.getEnumerableConstraint() != null;
    }

    @Nullable
    private DBSEntityReferrer getEnumerableConstraint() {
        if (this.valueController instanceof IAttributeController) {
            DBSDataContainer dataContainer = this.valueController.getDataController().getDataContainer();
            if (dataContainer == null || dataContainer.getDataSource() == null || !dataContainer.getDataSource().getContainer().isExtraMetadataReadEnabled()) {
                return null;
            }
            return ResultSetUtils.getEnumerableConstraint(((IAttributeController)this.valueController).getBinding());
        }
        return null;
    }

    public boolean createEditorSelector(final Composite parent) {
        DBSEntityAssociation association;
        if (!(this.valueController instanceof IAttributeController)) {
            return false;
        }
        this.refConstraint = this.getEnumerableConstraint();
        if (this.refConstraint == null) {
            return false;
        }
        DBSEntityReferrer dBSEntityReferrer = this.refConstraint;
        if (dBSEntityReferrer instanceof DBSEntityAssociation && (association = (DBSEntityAssociation)dBSEntityReferrer).getReferencedConstraint() != null) {
            final DBSEntity refTable = association.getReferencedConstraint().getParentObject();
            Composite labelGroup = UIUtils.createPlaceholder((Composite)parent, (int)2);
            labelGroup.setLayoutData((Object)new GridData(768));
            Link dictLabel = UIUtils.createLink((Composite)labelGroup, (String)("<a>" + refTable.getName() + "</a>"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkbenchWindow window = ReferenceValueEditor.this.valueController.getValueSite().getWorkbenchWindow();
                    UIUtils.runInUI((IRunnableContext)window, monitor -> {
                        DBNDatabaseNode tableNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)refTable, (boolean)true);
                        if (tableNode != null) {
                            NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)tableNode, (String)DatabaseDataEditor.class.getName(), (IWorkbenchWindow)window);
                        }
                    });
                }
            });
            dictLabel.setLayoutData((Object)new GridData(32));
            Button hintLabel = UIUtils.createPushButton((Composite)labelGroup, null, (String)ResultSetMessages.reference_value_editor_define_description_value, (DBPImage)UIIcon.CONFIGURATION, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(refTable);
                    if (editDictionaryPage.edit(parent.getShell())) {
                        ReferenceValueEditor.this.controller.reload(true);
                    }
                }
            });
            hintLabel.setLayoutData((Object)new GridData(896));
        }
        if (this.refConstraint instanceof DBSEntityAssociation) {
            this.valueFilterText = new Text(parent, 2432);
            this.valueFilterText.setLayoutData((Object)new GridData(768));
            this.valueFilterText.setMessage(ResultSetMessages.reference_value_editor_search_hint_value);
            this.valueFilterText.addModifyListener(e -> {
                String filterPattern = this.valueFilterText.getText();
                this.controller.filter(this.valueController.getValue(), filterPattern);
            });
        }
        this.editorSelector = new Table(parent, 68356);
        this.editorSelector.setLinesVisible(true);
        this.editorSelector.setHeaderVisible(true);
        this.editorSelector.setFont(ResultSetThemeSettings.instance.resultSetFont);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.editorSelector.setLayoutData((Object)gd);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.editorSelector, (int)16384, (String)ResultSetMessages.dialog_value_view_column_value);
        valueColumn.setData((Object)Boolean.TRUE);
        TableColumn descColumn = UIUtils.createTableColumn((Table)this.editorSelector, (int)16384, (String)ResultSetMessages.dialog_value_view_column_description);
        descColumn.setData((Object)Boolean.FALSE);
        SortListener sortListener = new SortListener();
        valueColumn.addListener(13, (Listener)sortListener);
        descColumn.addListener(13, (Listener)sortListener);
        if (!sortByValue) {
            this.editorSelector.setSortColumn(descColumn);
            this.editorSelector.setSortDirection(sortAsc ? 1024 : 128);
            this.prevSortColumn = descColumn;
        }
        this.editorSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ReferenceValueEditor.this.primeValueToSelection();
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            if (!this.valueEditor.isReadOnly()) {
                manager.add((IAction)new Action(ResultSetMessages.reference_value_editor_value_label){

                    public void run() {
                        ReferenceValueEditor.this.primeValueToSelection();
                    }
                });
            }
            manager.add((IAction)new CopyAction());
            manager.add((IContributionItem)new Separator());
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.editorSelector.setMenu(menuMgr.createContextMenu((Control)this.editorSelector));
        this.editorSelector.addDisposeListener(e -> menuMgr.dispose());
        Control control = this.valueEditor.getControl();
        ModifyListener modifyListener = e -> this.showCurrentValue();
        if (control instanceof Text) {
            ((Text)control).addModifyListener(modifyListener);
        } else if (control instanceof StyledText) {
            ((StyledText)control).addModifyListener(modifyListener);
        }
        Object curValue = this.valueController.getValue();
        this.controller.reset(curValue);
        ResultSetThemeSettings.instance.addPropertyListener("org.jkiss.dbeaver.sql.resultset.font", s -> this.showCurrentValue(), (Control)this.editorSelector);
        return true;
    }

    private void primeValueToSelection() {
        if (this.valueEditor.isReadOnly()) {
            return;
        }
        TableItem[] selection = this.editorSelector.getSelection();
        if (selection != null && selection.length > 0) {
            Object value = selection[0].getData();
            try {
                this.valueEditor.primeEditorValue(value);
            }
            catch (DBException e1) {
                log.error((Object)e1);
            }
        }
    }

    private void showCurrentValue() {
        TableItem[] items;
        Object curEditorValue;
        try {
            curEditorValue = this.valueEditor.extractEditorValue();
        }
        catch (DBException e1) {
            log.error((Object)e1);
            return;
        }
        String curTextValue = this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)this.valueController).getBinding(), curEditorValue, DBDDisplayFormat.EDIT);
        boolean newValueFound = false;
        this.editorSelector.setFont(ResultSetThemeSettings.instance.resultSetFont);
        TableItem[] tableItemArray = items = this.editorSelector.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (curTextValue.equalsIgnoreCase(item.getText(0)) || curTextValue.equalsIgnoreCase(item.getText(1))) {
                this.editorSelector.deselectAll();
                item.setFont(ResultSetThemeSettings.instance.resultSetFontBold);
                this.editorSelector.setSelection(item);
                this.editorSelector.showItem(item);
                newValueFound = true;
            } else {
                item.setFont(ResultSetThemeSettings.instance.resultSetFont);
            }
            ++n2;
        }
        if (!newValueFound) {
            this.controller.reset(curEditorValue);
        }
    }

    private void updateDictionarySelector(EnumValuesData valuesData) {
        if (this.editorSelector == null || this.editorSelector.isDisposed()) {
            return;
        }
        this.editorSelector.setRedraw(false);
        try {
            this.editorSelector.removeAll();
            for (DBDLabelValuePair entry : valuesData.keyValues) {
                TableItem discItem = new TableItem(this.editorSelector, 0);
                discItem.setText(0, valuesData.keyHandler.getValueDisplayString((DBSTypedObject)valuesData.keyColumn.getAttribute(), entry.getValue(), DBDDisplayFormat.EDIT));
                discItem.setText(1, entry.getLabel());
                discItem.setData(entry.getValue());
            }
            this.selectCurrentValue();
            UIUtils.packColumns((Table)this.editorSelector, (boolean)false);
        }
        finally {
            this.editorSelector.setRedraw(true);
        }
    }

    public ContributionItem[] getContributionItems() {
        return new ContributionItem[]{ActionUtils.makeActionContribution((IAction)this.actionGoBackward, (boolean)false), ActionUtils.makeActionContribution((IAction)this.actionGoForward, (boolean)false)};
    }

    private void selectCurrentValue() {
        Control editorControl = this.valueEditor.getControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            try {
                Object curValue = this.valueEditor.extractEditorValue();
                String curTextValue = this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)this.valueController).getBinding(), curValue, DBDDisplayFormat.EDIT);
                TableItem curItem = null;
                int curItemIndex = -1;
                TableItem[] items = this.editorSelector.getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    if (item.getText(0).equals(curTextValue)) {
                        curItem = item;
                        curItemIndex = i;
                    } else {
                        item.setFont(ResultSetThemeSettings.instance.resultSetFont);
                    }
                    ++i;
                }
                this.editorSelector.deselectAll();
                if (curItem != null) {
                    curItem.setFont(ResultSetThemeSettings.instance.resultSetFontBold);
                    this.editorSelector.setSelection(curItem);
                    this.editorSelector.showItem(curItem);
                    this.editorSelector.setTopIndex(curItemIndex);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private class CopyAction
    extends Action {
        public CopyAction() {
            super("Copy Value");
        }

        public void run() {
            StringBuilder result = new StringBuilder();
            TableItem[] tableItemArray = ReferenceValueEditor.this.editorSelector.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (!result.isEmpty()) {
                    result.append("\n");
                }
                result.append(item.getText(0));
                ++n2;
            }
            UIUtils.setClipboardContents((Display)ReferenceValueEditor.this.editorSelector.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)result.toString());
        }
    }

    private static class EnumValuesData {
        List<DBDLabelValuePair> keyValues;
        DBSEntityAttributeRef keyColumn;
        DBDValueHandler keyHandler;

        EnumValuesData(Collection<DBDLabelValuePair> keyValues, DBSEntityAttributeRef keyColumn, DBDValueHandler keyHandler) {
            this.keyValues = new ArrayList<DBDLabelValuePair>(keyValues);
            this.keyColumn = keyColumn;
            this.keyHandler = keyHandler;
        }
    }

    class SelectorLoaderService
    extends AbstractLoadService<EnumValuesData> {
        private final ReaderWriterLock.ExceptableFunction<DBSDictionaryAccessor, List<DBDLabelValuePair>, DBException> action;

        private SelectorLoaderService(ReaderWriterLock.ExceptableFunction<DBSDictionaryAccessor, List<DBDLabelValuePair>, DBException> action) {
            super(ResultSetMessages.dialog_value_view_job_selector_name + ReferenceValueEditor.this.valueController.getValueName() + " possible values");
            this.action = action;
            ReferenceValueEditor.this.actionGoBackward.setEnabled(false);
            ReferenceValueEditor.this.actionGoForward.setEnabled(false);
        }

        public EnumValuesData evaluate(@NotNull DBRProgressMonitor monitor) {
            if (ReferenceValueEditor.this.editorSelector.isDisposed() || ReferenceValueEditor.this.valueController.getExecutionContext() == null) {
                return null;
            }
            EnumValuesData[] result = new EnumValuesData[1];
            try {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)ReferenceValueEditor.this.valueController.getExecutionContext().getDataSource(), param -> {
                    enumValuesDataArray[0] = this.readEnum(monitor);
                });
            }
            catch (DBException e) {
                log.warn((Object)e.getMessage());
            }
            return result[0];
        }

        @Nullable
        private EnumValuesData readEnum(DBRProgressMonitor monitor) throws DBException {
            IAttributeController attributeController = (IAttributeController)ReferenceValueEditor.this.valueController;
            DBSEntityAttribute tableColumn = attributeController.getBinding().getEntityAttribute();
            if (tableColumn == null) {
                return null;
            }
            DBSEntityAttributeRef fkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)ReferenceValueEditor.this.refConstraint, (DBSEntityAttribute)tableColumn);
            if (fkColumn == null) {
                return null;
            }
            if (!(ReferenceValueEditor.this.refConstraint instanceof DBSEntityAssociation)) {
                return null;
            }
            DBSEntityAssociation association = (DBSEntityAssociation)ReferenceValueEditor.this.refConstraint;
            DBSEntityAttribute activeRefColumn = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)tableColumn, (boolean)false);
            if (activeRefColumn == null) {
                return null;
            }
            return this.getEnumValuesData(monitor, attributeController, fkColumn, association, activeRefColumn);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private EnumValuesData getEnumValuesData(@NotNull DBRProgressMonitor monitor, IAttributeController attributeController, DBSEntityAttributeRef fkColumn, DBSEntityAssociation association, DBSEntityAttribute refColumn) throws DBException {
            Object precAttribute;
            List allColumns = CommonUtils.safeList((List)ReferenceValueEditor.this.refConstraint.getAttributeReferences(monitor));
            ArrayList<DBDAttributeValue> restColumns = null;
            if (allColumns.size() > 1) {
                List<DBDAttributeBinding> rowAttributes = attributeController.getRowController().getRowAttributes();
                restColumns = new ArrayList<DBDAttributeValue>();
                for (DBSEntityAttributeRef precColumn : allColumns) {
                    DBDAttributeBinding rowAttr;
                    if (precColumn == fkColumn || (precAttribute = precColumn.getAttribute()) == null || (rowAttr = DBUtils.findBinding(rowAttributes, (DBSAttributeBase)precAttribute)) == null) continue;
                    Object precValue = attributeController.getRowController().getAttributeValue(rowAttr);
                    restColumns.add(new DBDAttributeValue((DBSAttributeBase)precAttribute, precValue));
                }
            }
            DBSEntityAttribute fkAttribute = fkColumn.getAttribute();
            DBSEntityConstraint refConstraint = association.getReferencedConstraint();
            DBSDictionary enumConstraint = refConstraint == null ? null : (DBSDictionary)refConstraint.getParentObject();
            if (fkAttribute == null) return null;
            if (enumConstraint == null) return null;
            try {
                precAttribute = null;
                Object var12_14 = null;
                try (DBSDictionaryAccessor accessor = enumConstraint.getDictionaryAccessor(monitor, refColumn, restColumns, sortAsc, !sortByValue);){
                    List enumValues = (List)this.action.apply((Object)accessor);
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (enumValues.isEmpty()) {
                        return null;
                    }
                    DBDValueHandler colHandler = DBUtils.findValueHandler((DBPDataSource)fkAttribute.getDataSource(), (DBSTypedObject)fkAttribute);
                    return new EnumValuesData(enumValues, fkColumn, colHandler);
                }
                catch (Throwable throwable) {
                    if (precAttribute == null) {
                        precAttribute = throwable;
                        throw precAttribute;
                    }
                    if (precAttribute == throwable) throw precAttribute;
                    ((Throwable)precAttribute).addSuppressed(throwable);
                    throw precAttribute;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw new DBException("Failed to load values", (Throwable)e);
            }
        }

        public Object getFamily() {
            return ReferenceValueEditor.this.valueController.getExecutionContext();
        }

        public boolean isForceCancel() {
            return false;
        }
    }

    private class SelectorLoaderVisualizer
    extends ProgressLoaderVisualizer<EnumValuesData> {
        public SelectorLoaderVisualizer(SelectorLoaderService loadingService) {
            super((ILoadService)loadingService, (Composite)ReferenceValueEditor.this.editorSelector);
        }

        public void visualizeLoading() {
            super.visualizeLoading();
        }

        public void completeLoading(EnumValuesData result) {
            boolean dataObtained = result != null && !result.keyValues.isEmpty();
            super.completeLoading((Object)result);
            super.visualizeLoading();
            if (result != null) {
                ReferenceValueEditor.this.updateDictionarySelector(result);
            }
            if (!ReferenceValueEditor.this.editorSelector.isDisposed()) {
                ReferenceValueEditor.this.actionGoBackward.setEnabled(ReferenceValueEditor.this.controller.isPrevPageAvailable());
                ReferenceValueEditor.this.actionGoForward.setEnabled(ReferenceValueEditor.this.controller.isNextPageAvailable());
                ReferenceValueEditor.this.editorSelector.setEnabled(dataObtained || ReferenceValueEditor.this.controller.searchText == null);
            }
        }
    }

    private class SortListener
    implements Listener {
        private int sortDirection = sortAsc ? 1024 : 128;

        public void handleEvent(Event event) {
            TableColumn column = (TableColumn)event.widget;
            if (ReferenceValueEditor.this.prevSortColumn == column) {
                this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
            }
            ReferenceValueEditor.this.prevSortColumn = column;
            sortByValue = (Boolean)column.getData();
            sortAsc = this.sortDirection == 1024;
            ReferenceValueEditor.this.editorSelector.setSortColumn(column);
            ReferenceValueEditor.this.editorSelector.setSortDirection(this.sortDirection);
            ReferenceValueEditor.this.controller.reload(false);
        }
    }

    private class ViewController {
        private final int pageSize;
        private final int halfPageSize;
        private long currPageNumber = 0L;
        private long maxKnownPage = 0L;
        private long minKnownPage = 0L;
        private boolean nextPageAvailable = false;
        private boolean prevPageAvailable = false;
        private boolean lastPageFound = false;
        private boolean firstPageFound = false;
        private String searchText = null;
        private Object keyValue = null;

        public ViewController(int pageSize) {
            this.pageSize = pageSize;
            this.halfPageSize = pageSize / 2;
        }

        public boolean isNextPageAvailable() {
            return !this.lastPageFound || this.currPageNumber < this.maxKnownPage;
        }

        public boolean isPrevPageAvailable() {
            return !this.firstPageFound || this.currPageNumber > this.minKnownPage;
        }

        public void goToNextPage() {
            if (this.nextPageAvailable) {
                ++this.currPageNumber;
                this.prevPageAvailable = true;
                this.reloadData();
            }
        }

        public void goToPrevPage() {
            if (this.prevPageAvailable) {
                --this.currPageNumber;
                this.nextPageAvailable = true;
                this.reloadData();
            }
        }

        public void filter(@Nullable Object valueToShow, @Nullable String pattern) {
            if (CommonUtils.isEmpty((String)CommonUtils.toString((Object)pattern))) {
                this.reset(valueToShow);
            } else if (CommonUtils.equalObjects((Object)String.valueOf(this.searchText), (Object)String.valueOf(pattern))) {
                ReferenceValueEditor.this.selectCurrentValue();
            } else {
                this.applyFilter(valueToShow, pattern);
            }
        }

        private void applyFilter(@Nullable Object valueToShow, @NotNull String pattern) {
            this.keyValue = valueToShow;
            this.searchText = pattern;
            this.resetPages();
            this.firstPageFound = true;
            this.reloadData();
        }

        public void reset(@Nullable Object valueToShow) {
            this.keyValue = valueToShow;
            this.searchText = null;
            this.resetPages();
            this.reloadData();
        }

        private void resetPages() {
            this.currPageNumber = 0L;
            this.minKnownPage = 0L;
            this.maxKnownPage = 0L;
            this.firstPageFound = false;
            this.lastPageFound = false;
        }

        public void reload(boolean refreshMainData) {
            if (this.searchText == null) {
                this.reset(this.keyValue);
            } else {
                this.applyFilter(this.keyValue, this.searchText);
            }
            if (refreshMainData && ReferenceValueEditor.this.rsController != null) {
                ReferenceValueEditor.this.rsController.refreshData(null);
            }
        }

        private void reloadData() {
            SelectorLoaderService loadingService = new SelectorLoaderService((ReaderWriterLock.ExceptableFunction<DBSDictionaryAccessor, List<DBDLabelValuePair>, DBException>)((ReaderWriterLock.ExceptableFunction)accessor -> {
                if (accessor.isKeyComparable() && this.keyValue != null) {
                    return this.loadComparableKeyValues((DBSDictionaryAccessor)accessor);
                }
                return this.loadNonComparableKeyValues((DBSDictionaryAccessor)accessor);
            }));
            if (ReferenceValueEditor.this.dictFilterJob != null) {
                ReferenceValueEditor.this.dictFilterJob.cancel();
            }
            ReferenceValueEditor.this.dictFilterJob = LoadingJob.createService((ILoadService)loadingService, (ILoadVisualizer)new SelectorLoaderVisualizer(loadingService));
            ReferenceValueEditor.this.dictFilterJob.schedule(250L);
        }

        private List<DBDLabelValuePair> loadNonComparableKeyValues(DBSDictionaryAccessor accessor) throws DBException {
            List data;
            if (this.searchText == null && this.keyValue != null) {
                data = accessor.getValueEntry(this.keyValue);
                this.estimateOnePage(true);
            } else {
                long offset = this.currPageNumber * (long)this.pageSize;
                data = this.searchText == null ? accessor.getValues(offset, this.pageSize) : accessor.getSimilarValues((Object)this.searchText, true, true, offset, (long)this.pageSize);
                if (this.currPageNumber == 0L) {
                    this.estimateOnePage(false);
                }
                this.estimateTail(data.size(), this.pageSize);
            }
            return data;
        }

        private List<DBDLabelValuePair> loadComparableKeyValues(DBSDictionaryAccessor accessor) throws DBException {
            Comparator comparator;
            List data;
            DBRProgressMonitor monitor = accessor.getProgressMonitor();
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (this.currPageNumber == 0L) {
                List prefix;
                List list = prefix = this.searchText == null ? accessor.getValuesNear(this.keyValue, true, 0L, (long)this.halfPageSize) : accessor.getSimilarValuesNear((Object)this.searchText, true, true, this.keyValue, true, 0L, (long)this.halfPageSize);
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                List suffix = this.searchText == null ? accessor.getValuesNear(this.keyValue, false, 0L, (long)this.halfPageSize) : accessor.getSimilarValuesNear((Object)this.searchText, true, true, this.keyValue, false, 0L, (long)this.halfPageSize);
                this.estimateHead(prefix.size(), this.halfPageSize);
                this.estimateTail(suffix.size(), this.halfPageSize);
                data = prefix;
                data.addAll(suffix);
            } else {
                long offset = (Math.abs(this.currPageNumber) - 1L) * (long)this.pageSize + (long)this.halfPageSize;
                if (this.currPageNumber < 0L) {
                    data = this.searchText == null ? accessor.getValuesNear(this.keyValue, true, offset, (long)this.pageSize) : accessor.getSimilarValuesNear((Object)this.searchText, true, true, this.keyValue, true, offset, (long)this.pageSize);
                    this.estimateHead(data.size(), this.pageSize);
                } else {
                    data = this.searchText == null ? accessor.getValuesNear(this.keyValue, false, offset, (long)this.pageSize) : accessor.getSimilarValuesNear((Object)this.searchText, true, true, this.keyValue, false, offset, (long)this.pageSize);
                    this.estimateTail(data.size(), this.pageSize);
                }
            }
            Comparator comparator2 = comparator = sortByValue ? (a, b) -> CommonUtils.compare((Object)a.getValue(), (Object)b.getValue()) : (a, b) -> CommonUtils.compare((Object)a.getLabel(), (Object)b.getLabel());
            if (!sortAsc) {
                comparator = comparator.reversed();
            }
            data.sort(comparator);
            return data;
        }

        private void estimateHead(int dataObtained, int dataExpected) {
            this.prevPageAvailable = dataObtained >= dataExpected;
            this.firstPageFound |= !this.prevPageAvailable;
            if (dataObtained > 0) {
                this.minKnownPage = Math.min(this.minKnownPage, this.currPageNumber);
            }
            if (this.firstPageFound) {
                this.currPageNumber = Math.max(this.currPageNumber, this.minKnownPage);
            }
        }

        private void estimateTail(int dataObtained, int dataExpected) {
            this.nextPageAvailable = dataObtained >= dataExpected;
            this.lastPageFound |= !this.nextPageAvailable;
            if (dataObtained > 0) {
                this.maxKnownPage = Math.max(this.maxKnownPage, this.currPageNumber);
            }
            if (this.lastPageFound) {
                this.currPageNumber = Math.min(this.currPageNumber, this.maxKnownPage);
            }
        }

        private void estimateOnePage(boolean noNextPage) {
            this.currPageNumber = 0L;
            this.maxKnownPage = 0L;
            this.minKnownPage = 0L;
            this.nextPageAvailable = !noNextPage;
            this.prevPageAvailable = false;
            this.lastPageFound = noNextPage;
            this.firstPageFound = true;
        }
    }
}

