/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.awt;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public interface PointShapeFactory {
    public Shape createPoint(Point2D var1);

    public static class X
    extends BasePointShapeFactory {
        public X() {
        }

        public X(double size) {
            super(size);
        }

        @Override
        public Shape createPoint(Point2D point) {
            GeneralPath path = new GeneralPath();
            path.moveTo((float)point.getX(), (float)(point.getY() - this.size * 1.0 / 8.0));
            path.lineTo((float)(point.getX() + this.size * 2.0 / 8.0), (float)(point.getY() - this.size / 2.0));
            path.lineTo((float)(point.getX() + this.size / 2.0), (float)(point.getY() - this.size / 2.0));
            path.lineTo((float)(point.getX() + this.size * 1.0 / 8.0), (float)point.getY());
            path.lineTo((float)(point.getX() + this.size / 2.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)(point.getX() + this.size * 2.0 / 8.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)point.getX(), (float)(point.getY() + this.size * 1.0 / 8.0));
            path.lineTo((float)(point.getX() - this.size * 2.0 / 8.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)(point.getX() - this.size / 2.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)(point.getX() - this.size * 1.0 / 8.0), (float)point.getY());
            path.lineTo((float)(point.getX() - this.size / 2.0), (float)(point.getY() - this.size / 2.0));
            path.lineTo((float)(point.getX() - this.size * 2.0 / 8.0), (float)(point.getY() - this.size / 2.0));
            path.closePath();
            return path;
        }
    }

    public static class Cross
    extends BasePointShapeFactory {
        public Cross() {
        }

        public Cross(double size) {
            super(size);
        }

        @Override
        public Shape createPoint(Point2D point) {
            float x1 = (float)(point.getX() - this.size / 2.0);
            float x2 = (float)(point.getX() - this.size / 4.0);
            float x3 = (float)(point.getX() + this.size / 4.0);
            float x4 = (float)(point.getX() + this.size / 2.0);
            float y1 = (float)(point.getY() - this.size / 2.0);
            float y2 = (float)(point.getY() - this.size / 4.0);
            float y3 = (float)(point.getY() + this.size / 4.0);
            float y4 = (float)(point.getY() + this.size / 2.0);
            GeneralPath path = new GeneralPath();
            path.moveTo(x2, y1);
            path.lineTo(x3, y1);
            path.lineTo(x3, y2);
            path.lineTo(x4, y2);
            path.lineTo(x4, y3);
            path.lineTo(x3, y3);
            path.lineTo(x3, y4);
            path.lineTo(x2, y4);
            path.lineTo(x2, y3);
            path.lineTo(x1, y3);
            path.lineTo(x1, y2);
            path.lineTo(x2, y2);
            path.lineTo(x2, y1);
            return path;
        }
    }

    public static class Circle
    extends BasePointShapeFactory {
        public Circle() {
        }

        public Circle(double size) {
            super(size);
        }

        @Override
        public Shape createPoint(Point2D point) {
            Ellipse2D.Double pointMarker = new Ellipse2D.Double(0.0, 0.0, this.size, this.size);
            pointMarker.x = point.getX() - this.size / 2.0;
            pointMarker.y = point.getY() - this.size / 2.0;
            return pointMarker;
        }
    }

    public static class Triangle
    extends BasePointShapeFactory {
        public Triangle() {
        }

        public Triangle(double size) {
            super(size);
        }

        @Override
        public Shape createPoint(Point2D point) {
            GeneralPath path = new GeneralPath();
            path.moveTo((float)point.getX(), (float)(point.getY() - this.size / 2.0));
            path.lineTo((float)(point.getX() + this.size / 2.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)(point.getX() - this.size / 2.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)point.getX(), (float)(point.getY() - this.size / 2.0));
            return path;
        }
    }

    public static class Star
    extends BasePointShapeFactory {
        public Star() {
        }

        public Star(double size) {
            super(size);
        }

        @Override
        public Shape createPoint(Point2D point) {
            GeneralPath path = new GeneralPath();
            path.moveTo((float)point.getX(), (float)(point.getY() - this.size / 2.0));
            path.lineTo((float)(point.getX() + this.size * 1.0 / 8.0), (float)(point.getY() - this.size * 1.0 / 8.0));
            path.lineTo((float)(point.getX() + this.size / 2.0), (float)(point.getY() - this.size * 1.0 / 8.0));
            path.lineTo((float)(point.getX() + this.size * 2.0 / 8.0), (float)(point.getY() + this.size * 1.0 / 8.0));
            path.lineTo((float)(point.getX() + this.size * 3.0 / 8.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)point.getX(), (float)(point.getY() + this.size * 2.0 / 8.0));
            path.lineTo((float)(point.getX() - this.size * 3.0 / 8.0), (float)(point.getY() + this.size / 2.0));
            path.lineTo((float)(point.getX() - this.size * 2.0 / 8.0), (float)(point.getY() + this.size * 1.0 / 8.0));
            path.lineTo((float)(point.getX() - this.size / 2.0), (float)(point.getY() - this.size * 1.0 / 8.0));
            path.lineTo((float)(point.getX() - this.size * 1.0 / 8.0), (float)(point.getY() - this.size * 1.0 / 8.0));
            path.closePath();
            return path;
        }
    }

    public static class Square
    extends BasePointShapeFactory {
        public Square() {
        }

        public Square(double size) {
            super(size);
        }

        @Override
        public Shape createPoint(Point2D point) {
            Rectangle2D.Double pointMarker = new Rectangle2D.Double(0.0, 0.0, this.size, this.size);
            pointMarker.x = point.getX() - this.size / 2.0;
            pointMarker.y = point.getY() - this.size / 2.0;
            return pointMarker;
        }
    }

    public static class Point
    extends BasePointShapeFactory {
        public Point() {
        }

        public Point(double size) {
            super(size);
        }

        @Override
        public Shape createPoint(Point2D point) {
            Line2D.Double pointMarker = new Line2D.Double(point.getX(), point.getY(), point.getX(), point.getY());
            return pointMarker;
        }
    }

    public static abstract class BasePointShapeFactory
    implements PointShapeFactory {
        public static final double DEFAULT_SIZE = 3.0;
        protected double size = 3.0;

        public BasePointShapeFactory() {
        }

        public BasePointShapeFactory(double size) {
            this.size = size;
        }

        @Override
        public abstract Shape createPoint(Point2D var1);
    }
}

