/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action;

import org.eclipse.jface.action.Action;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.utils.CommonUtils;

public class ChangeSortingAction
extends Action {
    private final Boolean descending;
    private final GroupingResultsContainer resultsContainer;
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String NONE = "";

    @NotNull
    public GroupingResultsContainer getResultsContainer() {
        return this.resultsContainer;
    }

    public ChangeSortingAction(@Nullable Boolean descending, @NotNull GroupingResultsContainer resultsContainer) {
        super(descending == null ? ResultSetMessages.grouping_panel_sorting_action_unsorted : (descending != false ? ResultSetMessages.grouping_panel_sorting_action_descending : ResultSetMessages.grouping_panel_sorting_action_ascending), 8);
        this.descending = descending;
        this.resultsContainer = resultsContainer;
    }

    public boolean isChecked() {
        DBPDataSource dataSource = this.getResultsContainer().getDataContainer().getDataSource();
        if (dataSource == null) {
            return false;
        }
        String defSorting = dataSource.getContainer().getPreferenceStore().getString("resultset.grouping.defaultSorting");
        if (CommonUtils.isEmpty((String)defSorting)) {
            return this.descending == null;
        }
        if (defSorting.equals(ASC)) {
            return Boolean.FALSE.equals(this.descending);
        }
        return Boolean.TRUE.equals(this.descending);
    }

    public void run() {
        String newValue = this.descending == null ? NONE : (this.descending != false ? DESC : ASC);
        DBPDataSource dataSource = this.getResultsContainer().getDataContainer().getDataSource();
        if (dataSource == null) {
            return;
        }
        dataSource.getContainer().getPreferenceStore().setValue("resultset.grouping.defaultSorting", newValue);
        dataSource.getContainer().persistConfiguration();
        try {
            this.getResultsContainer().rebuildGrouping();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.grouping_panel_error_title, ResultSetMessages.grouping_panel_error_change_sort_message, (Throwable)e);
        }
    }
}

