/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferAttributeTransformerDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

class AttributeTransformerSettingsDialog
extends BaseDialog {
    private static final Log log = Log.getLog(AttributeTransformerSettingsDialog.class);
    private final DatabaseMappingAttribute mapping;
    private final DataTransferAttributeTransformerDescriptor transformer;
    private PropertyTreeViewer propertiesEditor;
    private PropertySourceCustom propertySource;
    private Text infoText;

    public AttributeTransformerSettingsDialog(Shell parentShell, DatabaseMappingAttribute mapping, DataTransferAttributeTransformerDescriptor transformer) {
        super(parentShell, "Transformer " + transformer.getName() + " settings", null);
        this.mapping = mapping;
        this.transformer = transformer;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.createTransformSettingsArea(composite);
        this.updateTransformerInfo();
        return parent;
    }

    private void updateTransformerInfo() {
        if (this.infoText != null) {
            if (this.transformer != null && this.transformer.getDescription() != null) {
                this.infoText.setText(this.transformer.getDescription());
            } else {
                this.infoText.setText("");
            }
        }
        if (this.transformer != null) {
            List transformerProperties = this.transformer.getProperties();
            this.loadTransformerSettings(transformerProperties);
        } else {
            this.loadTransformerSettings(Collections.emptyList());
        }
    }

    private void saveTransformerSettings() {
        this.propertiesEditor.saveEditorValues();
        LinkedHashMap settings = this.mapping.getTransformerProperties();
        if (settings == null) {
            settings = new LinkedHashMap();
        }
        Map properties = this.propertySource.getPropertiesWithDefaults();
        for (Map.Entry prop : properties.entrySet()) {
            if (prop.getValue() == null) continue;
            settings.put((String)prop.getKey(), prop.getValue());
        }
        this.mapping.setTransformerProperties(settings);
    }

    private void createTransformSettingsArea(Composite composite) {
        Composite settingsPanel = UIUtils.createComposite((Composite)composite, (int)1);
        if (composite.getLayout() instanceof GridLayout) {
            settingsPanel.setLayoutData((Object)new GridData(1808));
        }
        Composite placeholder = UIUtils.createComposite((Composite)settingsPanel, (int)2);
        UIUtils.createLabelText((Composite)placeholder, (String)"Transformer", (String)this.transformer.getName(), (int)8);
        Label infoLabel = UIUtils.createControlLabel((Composite)placeholder, (String)"Info");
        infoLabel.setLayoutData((Object)new GridData(2));
        this.infoText = new Text(placeholder, 72);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.infoText.setLayoutData((Object)gd);
        this.propertiesEditor = new PropertyTreeViewer(settingsPanel, 2048);
        this.propertiesEditor.getControl().setFocus();
    }

    private void loadTransformerSettings(Collection<? extends DBPPropertyDescriptor> properties) {
        Map transformOptions = this.mapping.getTransformerProperties();
        if (transformOptions == null) {
            transformOptions = Collections.emptyMap();
        }
        this.propertySource = new PropertySourceCustom(properties, transformOptions);
        this.propertiesEditor.loadProperties((DBPPropertySource)this.propertySource);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void create() {
        super.create();
        if (this.propertySource != null && this.propertySource.getProperties().length == 0) {
            UIUtils.asyncExec(this::okPressed);
        }
    }

    protected void okPressed() {
        this.saveTransformerSettings();
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }
}

