/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.task;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.utils.CommonUtils;

public class SQLToolExecuteSettings<OBJECT_TYPE extends DBSObject>
implements DBTTaskSettingsInput<OBJECT_TYPE> {
    private static final Log log = Log.getLog(SQLToolExecuteSettings.class);
    private List<OBJECT_TYPE> objectList = new ArrayList<OBJECT_TYPE>();
    private final List<Throwable> warnings = new ArrayList<Throwable>();

    protected SQLToolExecuteSettings() {
    }

    public List<OBJECT_TYPE> getObjectList() {
        return this.objectList;
    }

    public void setObjectList(List<OBJECT_TYPE> objectList) {
        this.objectList = objectList;
    }

    public List<Throwable> getWarnings() {
        return this.warnings;
    }

    public void loadSettingsFromInput(@NotNull List<OBJECT_TYPE> inputObjects, @NotNull Map<String, Object> options) {
        this.objectList.addAll(inputObjects);
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        try {
            runnableContext.run(true, true, monitor -> {
                ArrayList<DBSObject> objList = new ArrayList<DBSObject>();
                for (Map objectConfig : JSONUtils.getObjectList((Map)config, (String)"objects")) {
                    String objectId = CommonUtils.toString(objectConfig.get("objectId"));
                    try {
                        DBSObject object = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)objectId);
                        if (object == null) continue;
                        objList.add(object);
                    }
                    catch (DBException e) {
                        log.error((Object)("Can't find object '" + objectId + "' in project '" + project.getName() + "'"));
                        this.warnings.add(e);
                    }
                }
                this.objectList.addAll(objList);
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void saveConfiguration(Map<String, Object> config) {
        ArrayList objectsConfig = new ArrayList();
        config.put("objects", objectsConfig);
        for (DBSObject obj : this.objectList) {
            LinkedHashMap<String, String> objectInfo = new LinkedHashMap<String, String>();
            objectInfo.put("project", obj.getDataSource().getContainer().getProject().getName());
            objectInfo.put("objectId", DBUtils.getObjectFullId((DBSObject)obj));
            objectsConfig.add(objectInfo);
        }
    }
}

