/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.decorations;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.time.LocalDate;
import java.time.Month;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.services.IDisposable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.decorations.Painter;
import org.jkiss.dbeaver.ui.controls.decorations.SnowflakePainter;

public class HolidayDecorations
implements IDisposable {
    public static final String PREF_UI_SHOW_HOLIDAY_DECORATIONS = "ui.show.holiday.decorations";
    private static final boolean ENABLED = HolidayDecorations.isEnabled0();
    private final Painter painter;
    private double frameTime;

    private HolidayDecorations(@NotNull Control control) {
        this.painter = new SnowflakePainter(control.getDisplay());
        Listener listener = event -> {
            switch (event.type) {
                case 11: {
                    this.reset(((Control)event.widget).getSize());
                    break;
                }
                case 9: {
                    this.paint(event.gc);
                    break;
                }
                case 12: {
                    this.dispose();
                }
            }
        };
        control.addListener(11, listener);
        control.addListener(9, listener);
        control.addListener(12, listener);
    }

    public static boolean install(final @NotNull Control control) {
        if (!HolidayDecorations.isEnabled()) {
            return false;
        }
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = environment.getDefaultScreenDevice();
        final int refreshRate = 1000 / Math.max(device.getDisplayMode().getRefreshRate(), 60);
        final HolidayDecorations decorations = new HolidayDecorations(control);
        final Display display = Display.getCurrent();
        Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                decorations.update(control.getSize());
                if (control.isVisible()) {
                    display.asyncExec(() -> {
                        if (!control.isDisposed()) {
                            control.redraw();
                        }
                    });
                    display.timerExec(refreshRate, (Runnable)this);
                } else {
                    display.timerExec(refreshRate * 10, (Runnable)this);
                }
            }
        };
        display.timerExec(refreshRate, timer);
        UIUtils.enableDoubleBuffering(control);
        return true;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    private static boolean isEnabled0() {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean(PREF_UI_SHOW_HOLIDAY_DECORATIONS)) {
            return false;
        }
        LocalDate current = LocalDate.now();
        return switch (current.getMonth()) {
            case Month.DECEMBER -> {
                if (current.getDayOfMonth() >= 24) {
                    yield true;
                }
                yield false;
            }
            case Month.JANUARY -> {
                if (current.getDayOfMonth() <= 7) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void dispose() {
        this.painter.dispose();
    }

    private void paint(@NotNull GC gc) {
        this.painter.paint(gc);
    }

    private void reset(@NotNull Point size) {
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        this.frameTime = (double)System.currentTimeMillis() / 1000.0;
        this.painter.reset(size.x, size.y);
    }

    private void update(@NotNull Point size) {
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        double currentTime = (double)System.currentTimeMillis() / 1000.0;
        double deltaTime = currentTime - this.frameTime;
        this.frameTime = currentTime;
        this.painter.update(size.x, size.y, deltaTime);
    }
}

