/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.introspection.JexlUberspect;

public final class SandboxUberspect
implements JexlUberspect {
    private final JexlUberspect uberspect;
    private final JexlSandbox sandbox;

    public SandboxUberspect(JexlUberspect theUberspect, JexlSandbox theSandbox) {
        if (theSandbox == null) {
            throw new NullPointerException("sandbox can not be null");
        }
        if (theUberspect == null) {
            throw new NullPointerException("uberspect can not be null");
        }
        this.uberspect = theUberspect;
        this.sandbox = theSandbox.copy();
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.uberspect.setClassLoader(loader);
    }

    @Override
    public int getVersion() {
        return this.uberspect.getVersion();
    }

    @Override
    public JexlMethod getConstructor(Object ctorHandle, Object ... args) {
        String className;
        if (ctorHandle instanceof Class) {
            Class clazz = (Class)ctorHandle;
            className = clazz.getName();
        } else if (ctorHandle != null) {
            className = ctorHandle.toString();
        } else {
            return null;
        }
        if (this.sandbox.execute(className, "") != null) {
            return this.uberspect.getConstructor(className, args);
        }
        return null;
    }

    @Override
    public JexlMethod getMethod(Object obj, String method, Object ... args) {
        String objClassName;
        String actual;
        if (obj != null && method != null && (actual = this.sandbox.execute(objClassName = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName(), method)) != null) {
            return this.uberspect.getMethod(obj, actual, args);
        }
        return null;
    }

    @Override
    public List<JexlUberspect.PropertyResolver> getResolvers(JexlOperator op, Object obj) {
        return this.uberspect.getResolvers(op, obj);
    }

    @Override
    public JexlPropertyGet getPropertyGet(Object obj, Object identifier) {
        return this.getPropertyGet(null, obj, identifier);
    }

    @Override
    public JexlPropertyGet getPropertyGet(List<JexlUberspect.PropertyResolver> resolvers, Object obj, Object identifier) {
        String actual;
        if (obj != null && identifier != null && (actual = this.sandbox.read(obj.getClass().getName(), identifier.toString())) != null) {
            return this.uberspect.getPropertyGet(resolvers, obj, actual);
        }
        return null;
    }

    @Override
    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg) {
        return this.getPropertySet(null, obj, identifier, arg);
    }

    @Override
    public JexlPropertySet getPropertySet(List<JexlUberspect.PropertyResolver> resolvers, Object obj, Object identifier, Object arg) {
        String actual;
        if (obj != null && identifier != null && (actual = this.sandbox.write(obj.getClass().getName(), identifier.toString())) != null) {
            return this.uberspect.getPropertySet(resolvers, obj, actual, arg);
        }
        return null;
    }

    @Override
    public Iterator<?> getIterator(Object obj) {
        return this.uberspect.getIterator(obj);
    }

    @Override
    public JexlArithmetic.Uberspect getArithmetic(JexlArithmetic arithmetic) {
        return this.uberspect.getArithmetic(arithmetic);
    }
}

