/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.utils.CommonUtils;

public class JSONUtils {
    public static final String DEFAULT_INDENT = "\t";
    public static final String EMPTY_INDENT = "";
    private static final Log log = Log.getLog(JSONUtils.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd['T'HH:mm:ss['.'SSS]['Z']]").withZone(ZoneId.of("UTC"));
    public static final Type MAP_TYPE_TOKEN = new TypeToken<Map<String, Object>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().create();

    public static String formatDate(java.util.Date date) {
        try {
            if (date instanceof Time) {
                return DateTimeFormatter.ISO_TIME.format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.of("UTC")));
            }
            if (date instanceof Date) {
                return DateTimeFormatter.ISO_DATE.format(((Date)date).toLocalDate());
            }
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC")).format(DATE_TIME_FORMATTER);
        }
        catch (Exception ex) {
            log.warn("Error formatting date to ISO-8601. Falling back to default string representation of " + date.getClass().getName(), ex);
            return date.toString();
        }
    }

    @Nullable
    public static java.util.Date parseDate(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer || value instanceof Long) {
            return new java.util.Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            TemporalAccessor accessor = DATE_TIME_FORMATTER.parse((String)value);
            LocalDate localDate = accessor.query(TemporalQueries.localDate());
            LocalTime localTime = accessor.query(TemporalQueries.localTime());
            if (localTime != null) {
                return java.util.Date.from(LocalDateTime.of(localDate, localTime).toInstant(ZoneOffset.UTC));
            }
            return java.util.Date.from(localDate.atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        throw new IllegalArgumentException("Cannot parse date from value '" + String.valueOf(value) + "'");
    }

    public static String formatISODate(java.util.Date date) {
        return "ISODate('" + JSONUtils.formatDate(date) + "')";
    }

    public static String escapeJsonString(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    result.append("\\").append(c);
                    break;
                }
                default: {
                    if (c < ' ') {
                        result.append(String.format("\\u%04x", c));
                        break;
                    }
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, @Nullable String value) throws IOException {
        json.name(name);
        if (value == null) {
            json.nullValue();
        } else {
            json.value(value);
        }
        return json;
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, @Nullable Number value) throws IOException {
        json.name(name);
        if (value == null) {
            json.nullValue();
        } else {
            json.value(value);
        }
        return json;
    }

    @NotNull
    public static JsonWriter fieldNE(@NotNull JsonWriter json, @NotNull String name, @Nullable String value) throws IOException {
        if (CommonUtils.isEmpty((String)value)) {
            return json;
        }
        json.name(name);
        json.value(value);
        return json;
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, long value) throws IOException {
        json.name(name);
        json.value(value);
        return json;
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, double value) throws IOException {
        json.name(name);
        json.value(value);
        return json;
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, boolean value) throws IOException {
        json.name(name);
        json.value(value);
        return json;
    }

    public static void serializeStringList(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Collection<String> list) throws IOException {
        JSONUtils.serializeStringList(json, tagName, list, true, false);
    }

    public static void serializeStringList(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Collection<String> list, boolean compact, boolean force) throws IOException {
        if (force || !CommonUtils.isEmpty(list)) {
            json.name(tagName);
            json.beginArray();
            if (compact) {
                json.setIndent(EMPTY_INDENT);
            }
            for (String include : CommonUtils.safeCollection(list)) {
                json.value(include);
            }
            json.endArray();
            if (compact) {
                json.setIndent(DEFAULT_INDENT);
            }
        }
    }

    public static void serializeObjectList(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Collection<?> list) throws IOException {
        if (!CommonUtils.isEmpty(list)) {
            json.name(tagName);
            JSONUtils.serializeCollection(json, list);
        }
    }

    public static void serializeProperties(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Map<String, ?> properties) throws IOException {
        if (!CommonUtils.isEmpty(properties)) {
            json.name(tagName);
            JSONUtils.serializeMap(json, properties);
        }
    }

    public static void serializeProperties(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Map<String, ?> properties, boolean allowEmptyValues) throws IOException {
        if (!CommonUtils.isEmpty(properties)) {
            json.name(tagName);
            JSONUtils.serializeMap(json, properties, allowEmptyValues);
        }
    }

    public static void serializeCollection(@NotNull JsonWriter json, @NotNull Collection<?> list) throws IOException {
        json.beginArray();
        for (Object value : CommonUtils.safeCollection(list)) {
            if (value == null) {
                json.nullValue();
                continue;
            }
            if (value instanceof Number) {
                Number numberValue = (Number)value;
                json.value(numberValue);
                continue;
            }
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                json.value(boolValue);
                continue;
            }
            if (value instanceof String) {
                String strValue = (String)value;
                json.value(strValue);
                continue;
            }
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                JSONUtils.serializeMap(json, mapValue);
                continue;
            }
            if (value instanceof Collection) {
                Collection colValue = (Collection)value;
                JSONUtils.serializeCollection(json, colValue);
                continue;
            }
            json.value(value.toString());
        }
        json.endArray();
    }

    public static void serializeMap(@NotNull JsonWriter json, @NotNull Map<String, ?> map) throws IOException {
        JSONUtils.serializeMap(json, map, false);
    }

    public static void serializeMap(@NotNull JsonWriter json, @NotNull Map<String, ?> map, boolean allowsEmptyValue) throws IOException {
        json.beginObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object propValue = entry.getValue();
            String fieldName = entry.getKey();
            if (propValue == null) continue;
            if (propValue instanceof Number) {
                JSONUtils.field(json, fieldName, (Number)propValue);
                continue;
            }
            if (propValue instanceof String) {
                String strValue = (String)propValue;
                if (!strValue.isEmpty()) {
                    JSONUtils.field(json, fieldName, strValue);
                    continue;
                }
                if (!allowsEmptyValue) continue;
                JSONUtils.field(json, fieldName, strValue);
                continue;
            }
            if (propValue instanceof Boolean) {
                Boolean bool = (Boolean)propValue;
                JSONUtils.field(json, fieldName, bool);
                continue;
            }
            if (propValue instanceof Collection) {
                Collection collectionValue = (Collection)propValue;
                JSONUtils.serializeObjectList(json, fieldName, collectionValue);
                continue;
            }
            if (propValue instanceof Map) {
                Map mapValue = (Map)propValue;
                JSONUtils.serializeProperties(json, fieldName, mapValue, allowsEmptyValue);
                continue;
            }
            if (propValue instanceof Enum) {
                Enum anEnum = (Enum)propValue;
                JSONUtils.field(json, fieldName, anEnum.name());
                continue;
            }
            if (propValue instanceof URI) {
                URI uri = (URI)propValue;
                JSONUtils.field(json, fieldName, uri.toString());
                continue;
            }
            log.debug("Unsupported JSON property '" + fieldName + "' type: " + propValue.getClass().getName() + ". Serializing as string.");
            JSONUtils.field(json, fieldName, propValue.toString());
        }
        json.endObject();
    }

    public static <OBJECT_TYPE> OBJECT_TYPE deserializeObject(@NotNull Map<String, Object> map, @NotNull Class<OBJECT_TYPE> type) throws DBCException {
        String json = GSON.toJson(map);
        return (OBJECT_TYPE)GSON.fromJson(json, type);
    }

    @NotNull
    public static Map<String, Object> parseMap(@NotNull Gson gson, @NotNull Reader reader) {
        Map result = (Map)gson.fromJson(reader, MAP_TYPE_TOKEN);
        if (result == null) {
            return new LinkedHashMap<String, Object>();
        }
        return result;
    }

    @NotNull
    public static Map<String, Object> getObject(@NotNull Map<String, Object> map, @NotNull String name) {
        Map object = (Map)map.get(name);
        return Objects.requireNonNullElseGet(object, LinkedHashMap::new);
    }

    @Nullable
    public static Map<String, Object> getObjectOrNull(@NotNull Map<String, Object> map, @NotNull String name) {
        return (Map)map.get(name);
    }

    @NotNull
    public static Iterable<Map.Entry<String, Map<String, Object>>> getNestedObjects(@NotNull Map<String, Object> map, @NotNull String name) {
        Map object = (Map)map.get(name);
        if (object == null) {
            return new ArrayList<Map.Entry<String, Map<String, Object>>>();
        }
        return object.entrySet();
    }

    public static <T> T getObjectProperty(@NotNull Object object, String name) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return (T)map.get(name);
        }
        log.error("Object " + String.valueOf(object) + " is not map");
        return null;
    }

    public static String getString(@NotNull Map<String, ?> map, String name) {
        Object value = map.get(name);
        return value == null ? null : value.toString();
    }

    public static String getString(@NotNull Map<String, ?> map, String name, String defValue) {
        Object value = map.get(name);
        return value == null ? defValue : value.toString();
    }

    @NotNull
    public static Timestamp getTimestamp(@NotNull Map<String, ?> attributes, @NotNull String name) {
        if (attributes.containsKey(name)) {
            try {
                long inst = JSONUtils.getLong(attributes, name, 0L);
                if (inst != 0L) {
                    return Timestamp.from(Instant.ofEpochMilli(inst));
                }
            }
            catch (Exception exception) {
                log.debug("Can't parse timestamp value from " + name);
            }
        }
        return new Timestamp(0L);
    }

    public static boolean getBoolean(@NotNull Map<String, ?> map, String name) {
        return CommonUtils.toBoolean(map.get(name));
    }

    public static boolean getBoolean(@NotNull Map<String, ?> map, String name, boolean defaultValue) {
        return CommonUtils.getBoolean(map.get(name), (boolean)defaultValue);
    }

    public static int getInteger(@NotNull Map<String, ?> map, String name) {
        return CommonUtils.toInt(map.get(name));
    }

    public static int getInteger(@NotNull Map<String, ?> map, String name, int defaultValue) {
        return CommonUtils.toInt(map.get(name), (int)defaultValue);
    }

    public static long getLong(@NotNull Map<String, ?> map, String name, long defaultValue) {
        return CommonUtils.toLong(map.get(name), (long)defaultValue);
    }

    public static Double getDouble(@NotNull Map<String, ?> map, String name) {
        return CommonUtils.toDouble(map.get(name));
    }

    @NotNull
    public static List<Map<String, Object>> getObjectList(@NotNull Map<String, Object> map, @NotNull String name) {
        Object value = map.get(name);
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<String> getStringList(@NotNull Map<String, Object> map, @NotNull String name) {
        Object value = map.get(name);
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static Map<String, Object> deserializeProperties(@NotNull Map<String, Object> map, String name) {
        Object propMap = map.get(name);
        if (propMap instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry pe : ((Map)propMap).entrySet()) {
                result.put(CommonUtils.toString(pe.getKey()), pe.getValue());
            }
            return result;
        }
        return null;
    }

    @NotNull
    public static Map<String, String> deserializeStringMap(@NotNull Map<String, Object> map, String name) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Object propMap = map.get(name);
        if (propMap instanceof Map) {
            Map pm = (Map)propMap;
            for (Map.Entry pe : pm.entrySet()) {
                result.put(CommonUtils.toString(pe.getKey()), CommonUtils.toString(pe.getValue()));
            }
        }
        return result;
    }

    @Nullable
    public static Map<String, String> deserializeStringMapOrNull(@NotNull Map<String, Object> map, String name) {
        Map mapVal;
        Object propMap = map.get(name);
        if (propMap instanceof Map && !(mapVal = (Map)propMap).isEmpty()) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Map.Entry pe : mapVal.entrySet()) {
                result.put(CommonUtils.toString(pe.getKey()), CommonUtils.toString(pe.getValue()));
            }
            return result;
        }
        return null;
    }

    @NotNull
    public static List<String> deserializeStringList(@NotNull Map<String, Object> map, String name) {
        ArrayList<String> result = new ArrayList<String>();
        Object propMap = map.get(name);
        if (propMap instanceof Collection) {
            Collection colValue = (Collection)propMap;
            for (Object pe : colValue) {
                result.add(CommonUtils.toString(pe));
            }
        }
        return result;
    }
}

