/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.piped;

import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.piped.PipeOperator;
import net.sf.jsqlparser.statement.piped.PipeOperatorVisitor;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;

public class UnPivotPipeOperator
extends PipeOperator {
    private Column valuesColumn;
    private Column nameColumn;
    private List<SelectItem<?>> pivotColumns;
    private Alias alias = null;

    public UnPivotPipeOperator(Column valuesColumn, Column nameColumn, List<SelectItem<?>> pivotColumns, Alias alias) {
        this.valuesColumn = valuesColumn;
        this.nameColumn = nameColumn;
        this.pivotColumns = pivotColumns;
        this.alias = alias;
    }

    public Column getValuesColumn() {
        return this.valuesColumn;
    }

    public UnPivotPipeOperator setValuesColumn(Column valuesColumn) {
        this.valuesColumn = valuesColumn;
        return this;
    }

    public Column getNameColumn() {
        return this.nameColumn;
    }

    public UnPivotPipeOperator setNameColumn(Column nameColumn) {
        this.nameColumn = nameColumn;
        return this;
    }

    public List<SelectItem<?>> getPivotColumns() {
        return this.pivotColumns;
    }

    public UnPivotPipeOperator setPivotColumns(List<SelectItem<?>> pivotColumns) {
        this.pivotColumns = pivotColumns;
        return this;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public UnPivotPipeOperator setAlias(Alias alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("|> ").append("UNPIVOT( ").append(this.valuesColumn).append(" FOR ").append(this.nameColumn).append(" IN (").append(Select.getStringList(this.pivotColumns)).append("))");
        if (this.alias != null) {
            builder.append(" ").append(this.alias);
        }
        builder.append("\n");
        return builder;
    }

    @Override
    public <T, S> T accept(PipeOperatorVisitor<T, S> visitor, S context) {
        return visitor.visit(this, context);
    }
}

