/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;

public class TableColumnSortListener
implements Listener {
    private final Table table;
    private int sortDirection = 1024;
    private TableColumn prevColumn = null;
    private final Comparator<TableItem> comparator;

    public TableColumnSortListener(@NotNull Table table, @NotNull Comparator<TableItem> comparator) {
        this.table = table;
        this.comparator = comparator;
    }

    public TableColumnSortListener(Table table, int columnIndex) {
        this.table = table;
        this.comparator = new DefaultComparator(columnIndex);
    }

    private static void sortTable(Table table, Comparator<TableItem> comparator) {
        int columnCount = table.getColumnCount();
        String[] values = new String[columnCount];
        Color[] foregrounds = new Color[columnCount];
        Color[] backgrounds = new Color[columnCount];
        TableItem[] items = table.getItems();
        int i = 1;
        while (i < items.length) {
            int j = 0;
            while (j < i) {
                TableItem item = items[i];
                if (comparator.compare(item, items[j]) < 0) {
                    int k = 0;
                    while (k < columnCount) {
                        values[k] = item.getText(k);
                        foregrounds[k] = item.getForeground(k);
                        backgrounds[k] = item.getBackground(k);
                        ++k;
                    }
                    Object data = item.getData();
                    Image image = item.getImage();
                    boolean checked = item.getChecked();
                    item.dispose();
                    item = new TableItem(table, 0, j);
                    item.setText(values);
                    item.setData(data);
                    item.setImage(image);
                    item.setChecked(checked);
                    int k2 = 0;
                    while (k2 < columnCount) {
                        if (foregrounds[k2] != null) {
                            item.setForeground(k2, foregrounds[k2]);
                        }
                        if (backgrounds[k2] != null) {
                            item.setBackground(k2, backgrounds[k2]);
                        }
                        ++k2;
                    }
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void handleEvent(Event e) {
        TableColumn column = (TableColumn)e.widget;
        if (this.prevColumn == column && e.doit) {
            this.sortDirection = switch (this.sortDirection) {
                case 1024 -> 128;
                case 128 -> 0;
                default -> 1024;
            };
        }
        this.prevColumn = column;
        this.table.setSortColumn(column);
        this.table.setSortDirection(this.sortDirection);
        TableColumnSortListener.sortTable(this.table, this.sortDirection == 128 ? this.comparator : this.comparator.reversed());
    }

    private static class DefaultComparator
    implements Comparator<TableItem> {
        private final Collator collator = Collator.getInstance(Locale.getDefault());
        private final int columnIndex;

        public DefaultComparator(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public int compare(TableItem o1, TableItem o2) {
            String text1 = o1.getText(this.columnIndex);
            String text2 = o2.getText(this.columnIndex);
            try {
                Double num2;
                Double num1 = DefaultComparator.getNumberFromString(text1);
                if (num1 != null && (num2 = DefaultComparator.getNumberFromString(text2)) != null) {
                    return (int)(num1 - num2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return this.collator.compare(text1, text2);
        }

        private static Double getNumberFromString(String str) {
            if (str.isEmpty()) {
                return null;
            }
            if (!Character.isDigit(str.charAt(0))) {
                return null;
            }
            int numLength = 1;
            while (numLength < str.length()) {
                if (Character.isWhitespace(str.charAt(numLength))) break;
                ++numLength;
            }
            if (numLength == str.length()) {
                return Double.parseDouble(str);
            }
            return Double.parseDouble(str.substring(0, numLength));
        }
    }
}

