/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorNested;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;

public class SQLSourceViewer<T extends DBPScriptObject & DBSObject>
extends SQLEditorNested<T> {
    protected Boolean separateFKStmts;
    protected Boolean showPermissions;
    protected Boolean showColumnComments;
    protected Boolean showFullDDL;
    private Boolean showPartitionsDDL;
    private final IAction OPEN_CONSOLE_ACTION = new Action(SQLEditorMessages.source_viewer_open_in_sql_console, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE)){

        public void run() {
            IDocument document = SQLSourceViewer.this.getDocument();
            if (document == null) {
                return;
            }
            String sqlText = document.get();
            ISelection selection = SQLSourceViewer.this.getSelectionProvider().getSelection();
            if (selection instanceof TextSelection && ((TextSelection)selection).getLength() > 0) {
                sqlText = ((TextSelection)selection).getText();
            }
            DBPDataSource dataSource = SQLSourceViewer.this.getDataSource();
            Object consoleName = SQLSourceViewer.this.getSourceViewerType();
            DBPScriptObject sourceObject = (DBPScriptObject)SQLSourceViewer.this.getSourceObject();
            if (sourceObject != null) {
                consoleName = (String)consoleName + " of <" + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)sourceObject), (DBPEvaluationContext)DBPEvaluationContext.UI) + ">";
            }
            SQLEditorHandlerOpenEditor.openSQLConsole(UIUtils.getActiveWorkbenchWindow(), new SQLNavigatorContext((DBSObject)dataSource), (String)consoleName, sqlText);
        }
    };

    protected String getSourceViewerType() {
        return "DDL";
    }

    @Override
    protected String getSourceText(DBRProgressMonitor monitor) throws DBException {
        DBPScriptObject sourceObject = (DBPScriptObject)this.getSourceObject();
        if (sourceObject == null) {
            return null;
        }
        if (!(sourceObject instanceof DBSEntity)) {
            return sourceObject == null ? null : sourceObject.getObjectDefinitionText(monitor, this.getSourceOptions());
        }
        StringBuilder sql = new StringBuilder(100);
        DBStructUtils.generateTableListDDL((DBRProgressMonitor)monitor, (StringBuilder)sql, List.of((DBSEntity)sourceObject), this.getSourceOptions(), (boolean)false);
        return sql.toString().trim();
    }

    protected Map<String, Object> getSourceOptions() {
        DBPScriptObject genObject;
        IEditorInput editorInput = this.getEditorInput();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (editorInput instanceof IDatabaseEditorInput) {
            Collection attributeNames = ((IDatabaseEditorInput)editorInput).getAttributeNames();
            options.put("ddl.source", true);
            if (!attributeNames.isEmpty()) {
                for (String name : attributeNames) {
                    Object attribute = ((IDatabaseEditorInput)editorInput).getAttribute(name);
                    options.put(name, attribute);
                }
            }
        }
        if ((genObject = (DBPScriptObject)this.getSourceObject()) instanceof DBPScriptObjectExt2) {
            DBPScriptObjectExt2 sourceObject = (DBPScriptObjectExt2)genObject;
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeNestedObjects")) {
                options.put("ddl.includeNestedObjects", this.getShowFullDDL());
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includePermissions")) {
                options.put("ddl.includePermissions", this.getShowPermissions());
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.skipForeignKeys") && sourceObject.supportsObjectDefinitionOption("ddl.onlyForeignKeys")) {
                options.put("ddl.separateForeignKeys", this.getSeparateFKStmts());
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeComments")) {
                options.put("ddl.includeComments", this.getShowColumnComments());
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includePartitions")) {
                options.put("ddl.includePartitions", this.getShowPartitionsDDL());
            }
        }
        return options;
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
    }

    @Override
    public void activatePart() {
        super.activatePart();
        DBPScriptObject sourceObject = (DBPScriptObject)this.getSourceObject();
        if (sourceObject != null && !((DBSObject)sourceObject).isPersisted() && this.isReadOnly()) {
            this.refreshPart((Object)this, true);
        }
    }

    @Override
    protected void contributeEditorCommands(IContributionManager toolBarManager) {
        super.contributeEditorCommands(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.OPEN_CONSOLE_ACTION);
        DBPScriptObject genObject = (DBPScriptObject)this.getSourceObject();
        if (genObject instanceof DBPScriptObjectExt2) {
            DBPScriptObjectExt2 sourceObject = (DBPScriptObjectExt2)genObject;
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeNestedObjects")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(SQLEditorMessages.source_viewer_show_ddl_text, 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE_EXTERNAL));
                        this.setToolTipText(SQLEditorMessages.source_viewer_show_ddl_tip);
                        this.setChecked(SQLSourceViewer.this.getShowFullDDL());
                    }

                    public void run() {
                        SQLSourceViewer.this.showFullDDL = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.includeNestedObjects", SQLSourceViewer.this.showFullDDL.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includePermissions")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(SQLEditorMessages.source_viewer_show_permissions_text, 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PERMISSIONS));
                        this.setToolTipText(SQLEditorMessages.source_viewer_show_permissions_tip);
                        this.setChecked(SQLSourceViewer.this.getShowPermissions());
                    }

                    public void run() {
                        SQLSourceViewer.this.showPermissions = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.includePermissions", SQLSourceViewer.this.showPermissions.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.skipForeignKeys") && sourceObject.supportsObjectDefinitionOption("ddl.onlyForeignKeys")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(SQLEditorMessages.source_viewer_separate_fk_text, 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_FOREIGN_KEY));
                        this.setToolTipText(SQLEditorMessages.source_viewer_separate_fk_tip);
                        this.setChecked(SQLSourceViewer.this.getSeparateFKStmts());
                    }

                    public void run() {
                        SQLSourceViewer.this.separateFKStmts = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.separateForeignKeys", SQLSourceViewer.this.separateFKStmts.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeComments")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(SQLEditorMessages.source_viewer_show_comments_text, 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_TEXT));
                        this.setToolTipText(SQLEditorMessages.source_viewer_show_comments_tip);
                        this.setChecked(SQLSourceViewer.this.getShowColumnComments());
                    }

                    public void run() {
                        SQLSourceViewer.this.showColumnComments = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.includeComments", SQLSourceViewer.this.showColumnComments.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includePartitions")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(SQLEditorMessages.source_viewer_show_partitions_ddl_text, 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PARTITION));
                        this.setToolTipText(SQLEditorMessages.source_viewer_show_partitions_ddl_tip);
                        this.setChecked(SQLSourceViewer.this.getShowPartitionsDDL());
                    }

                    public void run() {
                        SQLSourceViewer.this.showPartitionsDDL = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.includePartitions", SQLSourceViewer.this.showPartitionsDDL.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
        }
    }

    protected boolean getShowPermissions() {
        if (this.showPermissions == null) {
            this.showPermissions = this.getPreferenceStore().getBoolean("ddl.includePermissions");
        }
        return this.showPermissions;
    }

    protected boolean getSeparateFKStmts() {
        if (this.separateFKStmts == null) {
            this.separateFKStmts = this.getPreferenceStore().getBoolean("ddl.separateForeignKeys");
        }
        return this.separateFKStmts;
    }

    protected Boolean getShowColumnComments() {
        if (this.showColumnComments == null) {
            this.showColumnComments = this.getPreferenceStore().getBoolean("ddl.includeComments");
        }
        return this.showColumnComments;
    }

    protected Boolean getShowFullDDL() {
        if (this.showFullDDL == null) {
            this.showFullDDL = this.getPreferenceStore().getBoolean("ddl.includeNestedObjects");
        }
        return this.showFullDDL;
    }

    protected Boolean getShowPartitionsDDL() {
        if (this.showPartitionsDDL == null) {
            this.showPartitionsDDL = this.getPreferenceStore().getBoolean("ddl.includePartitions");
        }
        return this.showPartitionsDDL;
    }
}

