/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.internal.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleDependency;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class OracleDependencyGroup
implements DBSObject {
    private final DBSObject owner;
    private final boolean dependents;

    public OracleDependencyGroup(DBSObject owner, boolean dependents) {
        this.owner = owner;
        this.dependents = dependents;
    }

    @NotNull
    public static Collection<OracleDependencyGroup> of(@NotNull DBSObject owner) {
        return Collections.unmodifiableCollection(Arrays.asList(new OracleDependencyGroup(owner, false), new OracleDependencyGroup(owner, true)));
    }

    @Association
    public Collection<OracleDependency> getEntries(DBRProgressMonitor monitor) throws DBException {
        return OracleDependency.readDependencies(monitor, this.owner, this.dependents);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.dependents ? OracleMessages.edit_oracle_dependencies_dependent_name : OracleMessages.edit_oracle_dependencies_dependency_name;
    }

    @Nullable
    public String getDescription() {
        return this.dependents ? OracleMessages.edit_oracle_dependencies_dependent_description : OracleMessages.edit_oracle_dependencies_dependency_description;
    }

    public boolean isPersisted() {
        return this.owner.isPersisted();
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.owner;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.owner.getDataSource();
    }
}

