/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model.data;

import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.clickhouse.ClickhouseTypeParser;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseArrayType;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCArrayValueHandler;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ClickhouseArrayValueHandler
extends JDBCArrayValueHandler {
    public static final ClickhouseArrayValueHandler INSTANCE = new ClickhouseArrayValueHandler();
    public static final String ARRAY_DELIMITER = ",";
    public static final Set<Character> QUOTED_CHARS = Set.of(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\"'), Character.valueOf(' '), Character.valueOf('\\'));

    protected boolean convertSingleValueToArray() {
        return false;
    }

    protected boolean useGetArray(@NotNull DBCSession session, @NotNull DBSTypedObject type) {
        return true;
    }

    protected boolean useSetArray(@NotNull DBCSession session, @NotNull DBSTypedObject type) {
        return true;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
        ClickhouseArrayType arrayType = this.getArrayType(session, type);
        DBSDataType itemType = arrayType.getComponentType(session.getProgressMonitor());
        if (itemType == null) {
            throw new DBCException("Array type " + arrayType.getFullTypeName() + " doesn't have a component type");
        }
        if (object instanceof List) {
            List list = (List)object;
            return this.makeCollectionFromNestedJavaCollection((JDBCSession)session, itemType, list);
        }
        if (object instanceof Array) {
            Array array = (Array)object;
            if (itemType.getName().startsWith("Tuple")) {
                return this.makeCollectionFromTupleArray(session, itemType, array);
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    @NotNull
    private Object makeCollectionFromNestedJavaCollection(@NotNull JDBCSession session, @NotNull DBSDataType itemType, Collection<?> collection) throws DBCException {
        try {
            if (itemType instanceof ClickhouseArrayType) {
                ClickhouseArrayType arrayItemType = (ClickhouseArrayType)itemType;
                ArrayList<Object> convertedItems = new ArrayList<Object>(collection.size());
                for (Object item : collection) {
                    if (item instanceof Collection) {
                        Collection collectionItem = (Collection)item;
                        convertedItems.add(this.makeCollectionFromNestedJavaCollection(session, (DBSDataType)arrayItemType, collectionItem));
                        continue;
                    }
                    DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)arrayItemType);
                    convertedItems.add(valueHandler.getValueFromObject((DBCSession)session, (DBSTypedObject)arrayItemType, item, false, true));
                }
                DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)arrayItemType);
                return new JDBCCollection(session.getProgressMonitor(), arrayItemType.getComponentType(session.getProgressMonitor()), valueHandler, convertedItems.toArray());
            }
            DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType);
            return new JDBCCollection(session.getProgressMonitor(), itemType, valueHandler, collection.toArray());
        }
        catch (DBException e) {
            throw new DBCException("Can't extract array data from Java array", (Throwable)e);
        }
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (!DBUtils.isNullValue((Object)value) && value instanceof JDBCCollection) {
            JDBCCollection collection = (JDBCCollection)value;
            StringJoiner output = new StringJoiner(ARRAY_DELIMITER, "[", "]");
            int i = 0;
            while (i < collection.getItemCount()) {
                String member;
                Object item = collection.getItem(i);
                if (item instanceof DBDCollection) {
                    member = ClickhouseArrayValueHandler.getArrayMemberDisplayString(column, (DBDValueHandler)this, item, format);
                } else {
                    DBSDataType componentType = collection.getComponentType();
                    DBDValueHandler componentHandler = collection.getComponentValueHandler();
                    member = ClickhouseArrayValueHandler.getArrayMemberDisplayString((DBSTypedObject)componentType, componentHandler, item, format);
                }
                output.add(member);
                ++i;
            }
            return output.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }

    @NotNull
    private static String getArrayMemberDisplayString(@NotNull DBSTypedObject type, @NotNull DBDValueHandler handler, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (DBUtils.isNullValue((Object)value)) {
            return "NULL";
        }
        String string = handler.getValueDisplayString(type, value, format);
        if (ClickhouseArrayValueHandler.isQuotingRequired(type, string)) {
            return "'" + string.replaceAll("[\\\\\"]", "\\\\$0") + "'";
        }
        return string;
    }

    private static boolean isQuotingRequired(@NotNull DBSTypedObject type, @NotNull String value) {
        switch (type.getDataKind()) {
            case NUMERIC: 
            case ARRAY: {
                return false;
            }
            case STRING: 
            case DATETIME: 
            case UNKNOWN: {
                return true;
            }
        }
        if (value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return true;
        }
        int index = 0;
        while (index < value.length()) {
            if (QUOTED_CHARS.contains(Character.valueOf(value.charAt(index)))) {
                return true;
            }
            ++index;
        }
        return value.contains(ARRAY_DELIMITER);
    }

    @NotNull
    private Object makeCollectionFromTupleArray(@NotNull DBCSession session, @NotNull DBSDataType itemType, @NotNull Array array) {
        DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType);
        try {
            ArrayList<Object> tuples = new ArrayList<Object>();
            Object[] objectArray = (Object[])array.getArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object tuple = objectArray[n2];
                Object value = valueHandler.getValueFromObject(session, (DBSTypedObject)itemType, tuple, false, false);
                tuples.add(value);
                ++n2;
            }
            return new JDBCCollection(session.getProgressMonitor(), itemType, valueHandler, tuples.toArray());
        }
        catch (SQLException | DBCException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    private ClickhouseArrayType getArrayType(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        ClickhouseArrayType arrayType;
        try {
            arrayType = (ClickhouseArrayType)ClickhouseTypeParser.getType(session.getProgressMonitor(), (ClickhouseDataSource)session.getDataSource(), type.getFullTypeName());
        }
        catch (DBException dBException) {
            throw new DBCException("Can't resolve array data type " + type.getFullTypeName());
        }
        if (arrayType == null) {
            throw new DBCException("Can't resolve array data type " + type.getFullTypeName());
        }
        return arrayType;
    }
}

