/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.ui.views;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseProcedure;
import org.jkiss.dbeaver.ext.kingbase.ui.internal.KingbaseMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class CreateFunctionOrProcedurePage
extends BaseObjectEditPage {
    protected static final Log log = Log.getLog(CreateFunctionOrProcedurePage.class);
    private String name;
    private DBSProcedureType type;
    private final KingbaseProcedure parent;
    private final DBRProgressMonitor monitor;
    private PostgreLanguage language;
    private PostgreDataType returnType;
    private Combo returnTypeCombo;
    private boolean isFunction;

    public CreateFunctionOrProcedurePage(DBRProgressMonitor monitor, KingbaseProcedure parent, boolean isFunction) {
        super(isFunction ? KingbaseMessages.dialog_struct_create_function_title : KingbaseMessages.dialog_struct_create_procedure_title);
        this.parent = parent;
        this.monitor = monitor;
        this.isFunction = isFunction;
    }

    public PostgreLanguage getLanguage() {
        return this.language;
    }

    public PostgreDataType getReturnType() {
        return this.returnType;
    }

    protected Control createPageContents(Composite parent) {
        Combo typeCombo;
        Composite propsGroup = new Composite(parent, 0);
        propsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        propsGroup.setLayoutData((Object)gd);
        Text containerText = UIUtils.createLabelText((Composite)propsGroup, (String)KingbaseMessages.dialog_struct_create_procedure_container, (String)DBUtils.getObjectFullName((DBPNamedObject)this.parent.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.UI));
        containerText.setEditable(false);
        Text nameText = UIUtils.createLabelText((Composite)propsGroup, (String)KingbaseMessages.dialog_struct_create_procedure_label_name, null);
        nameText.addModifyListener(e -> {
            this.name = nameText.getText().trim();
            this.updatePageState();
        });
        if (this.getPredefinedProcedureType() == null) {
            typeCombo = UIUtils.createLabelCombo((Composite)propsGroup, (String)KingbaseMessages.dialog_struct_create_procedure_combo_type, (int)12);
            typeCombo.add(DBSProcedureType.PROCEDURE.name());
            typeCombo.add(DBSProcedureType.FUNCTION.name());
        } else {
            typeCombo = null;
        }
        typeCombo.setEnabled(false);
        propsGroup.setTabList((Control[])ArrayUtils.remove(Control.class, (Object[])propsGroup.getTabList(), (Object)containerText));
        if (this.isFunction) {
            this.createExtraControls(propsGroup);
        }
        if (typeCombo != null) {
            typeCombo.select(this.getDefaultProcedureType() == DBSProcedureType.FUNCTION ? 1 : 0);
        }
        return propsGroup;
    }

    protected void updateProcedureType(DBSProcedureType type) {
        this.returnTypeCombo.setEnabled(type.hasReturnValue());
    }

    protected void createExtraControls(Composite group) {
        ArrayList languages = new ArrayList();
        try {
            languages.addAll(this.parent.getDatabase().getLanguages(this.monitor));
        }
        catch (DBException e2) {
            log.error((Object)e2);
        }
        Combo languageCombo = UIUtils.createLabelCombo((Composite)group, (String)"Language", (int)12);
        for (PostgreLanguage lang : languages) {
            languageCombo.add(lang.getName());
        }
        languageCombo.addModifyListener(e -> {
            this.language = (PostgreLanguage)languages.get(languageCombo.getSelectionIndex());
        });
        languageCombo.setText("sql");
        ArrayList<PostgreDataType> dataTypes = new ArrayList<PostgreDataType>(this.parent.getDatabase().getLocalDataTypes());
        dataTypes.sort(Comparator.comparing(PostgreDataType::getName));
        this.returnTypeCombo = UIUtils.createLabelCombo((Composite)group, (String)"Return type", (int)4);
        for (PostgreDataType dt : dataTypes) {
            this.returnTypeCombo.add(dt.getName());
        }
        this.returnTypeCombo.addModifyListener(e -> {
            String dtName = this.returnTypeCombo.getText();
            this.returnType = !CommonUtils.isEmpty((String)dtName) ? this.parent.getDatabase().getLocalDataType(dtName) : null;
        });
        this.returnTypeCombo.setText("int4");
    }

    public DBSProcedureType getProcedureType() {
        DBSProcedureType procedureType = this.getPredefinedProcedureType();
        return procedureType == null ? this.type : procedureType;
    }

    public DBSProcedureType getPredefinedProcedureType() {
        return null;
    }

    public DBSProcedureType getDefaultProcedureType() {
        return this.isFunction ? DBSProcedureType.FUNCTION : DBSProcedureType.PROCEDURE;
    }

    public String getProcedureName() {
        return DBObjectNameCaseTransformer.transformName((DBPDataSource)this.parent.getDataSource(), (String)this.name);
    }

    public boolean isPageComplete() {
        return !CommonUtils.isEmpty((String)this.name);
    }

    public DBSObject getObject() {
        return null;
    }
}

