/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.tidb.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEngine;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.tidb.model.plan.TiDBPlanAnalyzer;
import org.jkiss.dbeaver.ext.tidb.mysql.model.TiDBDialect;
import org.jkiss.dbeaver.ext.tidb.mysql.model.TiDBMySQLDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStandardValueHandlerProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class TiDBMySQLDataSource
extends MySQLDataSource {
    private static final Log log = Log.getLog(MySQLDataSource.class);
    private static final String CONN_ATTR_NAME = "connectionAttributes";
    private static final String PROP_APPLICATION_NAME = "program_name";
    private String tidbVersion = "";

    public String getServerVersion() {
        return this.tidbVersion;
    }

    public TiDBMySQLDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new TiDBDialect());
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"TiDB version fetch");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT VERSION() AS VERSION");){
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.tidbVersion = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VERSION");
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException ex) {
                log.error((Object)ex);
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new TiDBPlanAnalyzer(this));
        }
        if (adapter == DBDValueHandlerProvider.class) {
            return adapter.cast(new JDBCStandardValueHandlerProvider());
        }
        return (T)super.getAdapter(adapter);
    }

    public MySQLEngine getEngine(String name) {
        return (MySQLEngine)DBUtils.findObject((Collection)this.getEngines(), (String)name, (boolean)true);
    }

    public MySQLEngine getDefaultEngine() {
        return this.getEngine("tidb");
    }

    public MySQLPrivilege getPrivilege(DBRProgressMonitor monitor, String name) throws DBException {
        if (name.equalsIgnoreCase("SHOW DB")) {
            return (MySQLPrivilege)DBUtils.findObject((Collection)this.getPrivileges(monitor), (String)"Show databases", (boolean)true);
        }
        return (MySQLPrivilege)DBUtils.findObject((Collection)this.getPrivileges(monitor), (String)name, (boolean)true);
    }

    public Collection<? extends MySQLCatalog> getChildren(@NotNull DBRProgressMonitor monitor) {
        return this.getCatalogs();
    }

    public MySQLCatalog getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) {
        return this.getCatalog(childName);
    }

    @NotNull
    public Class<? extends MySQLCatalog> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return MySQLCatalog.class;
    }

    public boolean supportsInformationSchema() {
        return true;
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        super.createDataSourceInfo(monitor, metaData);
        return new TiDBMySQLDataSourceInfo(this, metaData);
    }

    public boolean supportsSequences() {
        return this.isServerVersionAtLeast(4, 0);
    }

    public boolean isServerVersionAtLeast(int major, int minor) {
        Version tidbVersion = this.getInfo().getDatabaseVersion();
        if (tidbVersion.getMajor() < major) {
            return false;
        }
        return tidbVersion.getMajor() != major || tidbVersion.getMinor() >= minor;
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        Map props = super.getInternalConnectionProperties(monitor, driver, context, purpose, connectionInfo);
        Object appName = DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose);
        appName = "dbeaver_tidb_plugin" + (String)(CommonUtils.isEmpty((String)appName) ? "" : "(" + (String)appName + ")");
        Object connAttr = (String)props.get(CONN_ATTR_NAME);
        connAttr = "program_name:" + (String)appName + (String)(CommonUtils.isEmpty((String)connAttr) ? "" : "," + (String)connAttr);
        props.put(CONN_ATTR_NAME, connAttr);
        return props;
    }
}

