/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.editors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.session.SQLServerSession;
import org.jkiss.dbeaver.ext.mssql.model.session.SQLServerSessionManager;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;
import org.jkiss.utils.CommonUtils;

public class SQLServerSessionEditor
extends AbstractSessionEditor {
    private KillSessionAction terminateQueryAction;
    private boolean showOnlyConnections = true;

    public void createEditorControl(Composite parent) {
        this.terminateQueryAction = new KillSessionAction();
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<SQLServerSession>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new SQLServerSessionManager((SQLServerDataSource)executionContext.getDataSource())){

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Only connections", 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
                        this.setToolTipText("Show only physical connections");
                        this.setChecked((this).SQLServerSessionEditor.this.showOnlyConnections);
                    }

                    public void run() {
                        (this).SQLServerSessionEditor.this.showOnlyConnections = this.isChecked();
                        SQLServerSessionEditor.this.refreshPart((Object)SQLServerSessionEditor.this, true);
                    }
                }, (boolean)true));
                contributionManager.add((IContributionItem)new Separator());
                contributionManager.add((IAction)SQLServerSessionEditor.this.terminateQueryAction);
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                SQLServerSessionEditor.this.terminateQueryAction.setEnabled(session != null);
            }

            protected void loadSettings(IDialogSettings settings) {
                SQLServerSessionEditor.this.showOnlyConnections = CommonUtils.getBoolean((String)settings.get("showOnlyConnections"), (boolean)true);
                super.loadSettings(settings);
            }

            protected void saveSettings(IDialogSettings settings) {
                super.saveSettings(settings);
                settings.put("showOnlyConnections", SQLServerSessionEditor.this.showOnlyConnections);
            }

            public Map<String, Object> getSessionOptions() {
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (SQLServerSessionEditor.this.showOnlyConnections) {
                    options.put("showOnlyConnections", true);
                }
                return options;
            }
        };
    }

    private class KillSessionAction
    extends Action {
        KillSessionAction() {
            super("Terminate", UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP"));
        }

        public void run() {
            List sessions = SQLServerSessionEditor.this.getSessionsViewer().getSelectedSessions();
            if (sessions != null && UIUtils.confirmAction((Shell)SQLServerSessionEditor.this.getSite().getShell(), (String)this.getText(), (String)NLS.bind((String)"Terminate session {0}?", (Object)sessions))) {
                SQLServerSessionEditor.this.getSessionsViewer().alterSessions(sessions, null);
            }
        }
    }
}

