/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.navigator.itemlist.ItemListControl;
import org.jkiss.utils.CommonUtils;

public class SuggestionInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private static final Log log = Log.getLog(SuggestionInformationControl.class);
    private Composite infoComposite;
    private Object input;
    private Font boldFont;
    private Composite tableComposite;
    private Composite mainComposite;
    private ItemListControl itemListControl;

    public SuggestionInformationControl(Shell parentShell, boolean isResizable) {
        super(parentShell, isResizable);
        this.create();
    }

    protected void createContent(Composite parent) {
        GridData mainGridData = new GridData(1808);
        this.mainComposite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.mainComposite.setLayoutData((Object)mainGridData);
        GridData infoGridData = new GridData(768);
        this.infoComposite = UIUtils.createPlaceholder((Composite)this.mainComposite, (int)1);
        this.infoComposite.setLayoutData((Object)infoGridData);
        this.tableComposite = UIUtils.createPlaceholder((Composite)this.mainComposite, (int)1);
        this.tableComposite.setLayoutData((Object)mainGridData);
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)parent.getFont());
        this.boldFont = fontDescriptor.setStyle(1).createFont((Device)parent.getDisplay());
    }

    public boolean hasContents() {
        return this.input != null;
    }

    public void setInput(Object input) {
        this.input = input;
        if (input instanceof DBPNamedObject && !this.infoComposite.isDisposed() && !this.tableComposite.isDisposed()) {
            this.createMetadataFields((DBPNamedObject)input);
            if (input instanceof DBSTable) {
                this.createTreeControl((DBSTable)input);
            }
        }
    }

    private void createMetadataFields(final @NotNull DBPNamedObject input) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 0;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        final Composite metadataComposite = new Composite(this.infoComposite, 0);
        metadataComposite.setLayout((Layout)layout);
        metadataComposite.setLayoutData((Object)new GridData(768));
        final DBPNamedObject[] targetObject = new DBPNamedObject[]{input};
        AbstractJob resolveObject = new AbstractJob("Resolving object"){

            protected IStatus run(DBRProgressMonitor monitor) {
                if (input instanceof DBSObjectReference) {
                    try {
                        targetObject[0] = ((DBSObjectReference)input).resolveObject(monitor);
                    }
                    catch (DBException e) {
                        log.error((Object)"Error resolving object", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        resolveObject.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UIUtils.syncExec(() -> {
                    if (!(metadataComposite.isDisposed() || SuggestionInformationControl.this.infoComposite.isDisposed() || SuggestionInformationControl.this.mainComposite.isDisposed())) {
                        PropertyCollector collector = new PropertyCollector((Object)targetObject[0], false);
                        collector.collectProperties();
                        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = collector.getProperties();
                        int n = dBPPropertyDescriptorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DBPPropertyDescriptor descriptor = dBPPropertyDescriptorArray[n2];
                            String propertyString = DBInfoUtils.getPropertyString((PropertyCollector)collector, (DBPPropertyDescriptor)descriptor);
                            if (!CommonUtils.isEmpty((String)propertyString) && descriptor.hasFeature("viewable")) {
                                Composite placeholder = UIUtils.createPlaceholder((Composite)metadataComposite, (int)2);
                                placeholder.setLayoutData((Object)new GridData(32));
                                Label label = new Label(placeholder, 8);
                                label.setText(descriptor.getDisplayName() + ":");
                                label.setFont(SuggestionInformationControl.this.boldFont);
                                Text valueText = new Text(placeholder, 8);
                                valueText.setText(propertyString);
                            }
                            ++n2;
                        }
                        SuggestionInformationControl.this.infoComposite.layout(true, true);
                        SuggestionInformationControl.this.mainComposite.layout(true, true);
                    }
                });
            }
        });
        resolveObject.schedule();
    }

    private void createTreeControl(@NotNull DBSTable input) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 0;
        gridData.verticalSpan = 0;
        SubEditorSite subSite = new SubEditorSite(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
        final DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)input);
        this.itemListControl = new ItemListControl(this.tableComposite, 0, (IWorkbenchSite)subSite, (DBNNode)node, null){

            @NotNull
            protected String getListConfigId(List<Class<?>> classList) {
                return "Suggestion/" + super.getListConfigId(classList);
            }
        };
        this.itemListControl.setLayoutData((Object)gridData);
        final Object[] columnNodes = new Object[1];
        AbstractJob abstractJob = new AbstractJob("Populating table tip columns"){

            protected IStatus run(DBRProgressMonitor monitor) {
                monitor.beginTask("load table columns", 1);
                try {
                    try {
                        columnNodes[0] = SuggestionInformationControl.this.getColumnNodes(monitor, (DBNNode)node);
                    }
                    catch (DBException e) {
                        log.error((Object)"Error reading table columns", (Throwable)e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        abstractJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UIUtils.syncExec(() -> {
                    if (SuggestionInformationControl.this.itemListControl != null && !SuggestionInformationControl.this.itemListControl.isDisposed()) {
                        Collection columnNodeList = (Collection)columnNodes[0];
                        if (CommonUtils.isEmpty((Collection)columnNodeList)) {
                            SuggestionInformationControl.this.itemListControl.dispose();
                        } else {
                            SuggestionInformationControl.this.itemListControl.appendListData(columnNodeList);
                            int i = 0;
                            while (i < SuggestionInformationControl.this.itemListControl.getColumnController().getColumnsCount()) {
                                SuggestionInformationControl.this.itemListControl.getColumnController().setIsColumnVisible(i, false);
                                ++i;
                            }
                            SuggestionInformationControl.this.itemListControl.setIsColumnVisibleById("ordinalPosition", true);
                            SuggestionInformationControl.this.itemListControl.setIsColumnVisibleById("name", true);
                            SuggestionInformationControl.this.itemListControl.setIsColumnVisibleById("fullTypeName", true);
                            SuggestionInformationControl.this.itemListControl.setIsColumnVisibleById("identity", true);
                            SuggestionInformationControl.this.itemListControl.setIsColumnVisibleById("description", true);
                            SuggestionInformationControl.this.itemListControl.getColumnController().createColumns(false);
                            SuggestionInformationControl.this.itemListControl.getItemsViewer().refresh();
                            SuggestionInformationControl.this.itemListControl.getColumnController().autoSizeColumns();
                        }
                        SuggestionInformationControl.this.tableComposite.layout(true, true);
                    }
                });
            }
        });
        abstractJob.schedule();
    }

    @NotNull
    private Collection<DBNNode> getColumnNodes(@NotNull DBRProgressMonitor monitor, @Nullable DBNNode node) throws DBException {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<DBNNode> children = new ArrayList<DBNNode>();
        DBNNode[] dBNNodeArray = node.getChildren(monitor);
        int n = dBNNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNDatabaseFolder) {
                Class childrenClass = ((DBNDatabaseFolder)child).getChildrenClass();
                if (childrenClass != null && DBSTableColumn.class.isAssignableFrom(childrenClass)) {
                    if (this.itemListControl != null && !this.itemListControl.isDisposed()) {
                        this.itemListControl.setRootNode(child);
                    }
                    DBNNode[] folderChildren = child.getChildren(monitor);
                    children.addAll(List.of(folderChildren));
                }
            } else {
                children.add(child);
            }
            ++n2;
        }
        return children;
    }

    public void dispose() {
        this.boldFont.dispose();
        super.dispose();
    }
}

