/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.List;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;

public class SQLQueryComplexName {
    @NotNull
    private final List<String> parts;
    @Nullable
    private final SQLQueryQualifiedName qualifiedName;

    public SQLQueryComplexName(String ... parts) {
        this.parts = List.of(parts);
        this.qualifiedName = null;
    }

    public SQLQueryComplexName(@NotNull List<String> parts) {
        this.parts = parts;
        this.qualifiedName = null;
    }

    public SQLQueryComplexName(@NotNull SQLQueryQualifiedName name) {
        this.parts = name.toListOfStrings();
        this.qualifiedName = name;
    }

    @NotNull
    public List<String> getParts() {
        return this.parts;
    }

    @Nullable
    public SQLQueryComplexName trimEnd() {
        return this.parts.size() < 2 ? null : new SQLQueryComplexName(this.parts.subList(0, this.parts.size() - 1));
    }

    @Nullable
    public SQLQueryQualifiedName qualifiedName() {
        return this.qualifiedName;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void name;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SQLQueryComplexName)) {
            return false;
        }
        SQLQueryComplexName sQLQueryComplexName = (SQLQueryComplexName)o;
        return Objects.equals(this.parts, name.parts);
    }

    public int hashCode() {
        return Objects.hashCode(this.parts);
    }
}

