/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNodePointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.jdom.Attribute;

public class JDOMAttributePointer
extends NodePointer {
    private final Attribute attr;
    private static final long serialVersionUID = 8896050354479644028L;

    public JDOMAttributePointer(NodePointer parent, Attribute attr) {
        super(parent);
        this.attr = attr;
    }

    @Override
    public QName getName() {
        return new QName(JDOMNodePointer.getPrefix(this.attr), JDOMNodePointer.getLocalName(this.attr));
    }

    @Override
    public String getNamespaceURI() {
        String uri = this.attr.getNamespaceURI();
        if (uri != null && uri.isEmpty()) {
            uri = null;
        }
        return uri;
    }

    @Override
    public Object getValue() {
        return this.attr.getValue();
    }

    @Override
    public Object getBaseValue() {
        return this.attr;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Object getImmediateNode() {
        return this.attr;
    }

    @Override
    public boolean isActual() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        this.attr.setValue((String)TypeUtils.convert(value, String.class));
    }

    @Override
    public void remove() {
        this.attr.getParent().removeAttribute(this.attr);
    }

    @Override
    public String asPath() {
        StringBuilder buffer = new StringBuilder();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append('@');
        buffer.append(this.getName());
        return buffer.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this.attr);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JDOMAttributePointer && ((JDOMAttributePointer)object).attr == this.attr;
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }
}

