/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.duckdb.model.DuckDBDataSource;
import org.jkiss.dbeaver.ext.duckdb.model.DuckDBGenericCatalog;
import org.jkiss.dbeaver.ext.duckdb.model.DuckDBSequence;
import org.jkiss.dbeaver.ext.duckdb.model.DuckDataTypeCache;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DuckMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(DuckMetaModel.class);
    private static final Set<String> SYSTEM_SCHEMA_NAMES = Set.of("information_schema", "pg_catalog");

    public JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> createDataTypeCache(@NotNull GenericStructContainer container) {
        return new DuckDataTypeCache(container);
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) throws DBException {
        String objectDDL = this.getObjectDDL(monitor, sourceObject, "duckdb_tables()", "table_name");
        if (objectDDL == null) {
            return super.getTableDDL(monitor, sourceObject, options);
        }
        return objectDDL;
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        String objectDDL = this.getObjectDDL(monitor, (GenericTableBase)sourceObject, "duckdb_views()", "view_name");
        if (objectDDL == null) {
            return "-- DuckDB view definition not found";
        }
        return objectDDL;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private String getObjectDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull String sysViewName, @NotNull String objectColumnName) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement statement = session.prepareStatement("SELECT * FROM duckdb_sequences() WHERE database_name = ? AND schema_name = ?");
        statement.setString(1, container.getCatalog().getName());
        statement.setString(2, container.getName());
        return statement;
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sequence_name");
        if (CommonUtils.isEmpty((String)name)) {
            log.debug((Object)"Skip a sequence with an empty name.");
            return null;
        }
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        return new DuckDBSequence(container, name, description, JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"last_value"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"min_value"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"max_value"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"increment_by"), dbResult);
    }

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new DuckDBDataSource(monitor, container, this);
    }

    public boolean isSystemSchema(@NotNull GenericSchema schema) {
        return SYSTEM_SCHEMA_NAMES.contains(schema.getName());
    }

    public GenericCatalog createCatalogImpl(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        return new DuckDBGenericCatalog(dataSource, catalogName);
    }
}

