/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractObjectCache<OWNER extends DBSObject, OBJECT extends DBSObject>
implements DBSObjectCache<OWNER, OBJECT> {
    private static final Log log = Log.getLog(AbstractObjectCache.class);
    private List<OBJECT> objectList;
    private Map<String, OBJECT> objectMap;
    protected volatile boolean fullCache = false;
    protected volatile boolean caseSensitive = true;
    private Comparator<OBJECT> listOrderComparator;
    private final Object cacheSync = new Object();

    protected AbstractObjectCache() {
    }

    public Object getCacheSync() {
        return this.cacheSync;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Comparator<OBJECT> getListOrderComparator() {
        return this.listOrderComparator;
    }

    public void setListOrderComparator(Comparator<OBJECT> listOrderComparator) {
        this.listOrderComparator = listOrderComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<OBJECT> getCachedObjects() {
        Object object = this.cacheSync;
        synchronized (object) {
            return this.objectList == null ? Collections.emptyList() : this.objectList;
        }
    }

    public <SUB_TYPE> List<SUB_TYPE> getTypedObjects(@NotNull DBRProgressMonitor monitor, OWNER owner, Class<SUB_TYPE> type) throws DBException {
        ArrayList<SUB_TYPE> result = new ArrayList<SUB_TYPE>();
        for (DBSObject object : this.getAllObjects(monitor, owner)) {
            if (!type.isInstance(object)) continue;
            result.add(type.cast(object));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OBJECT getCachedObject(@Nullable String name) {
        Object object = this.cacheSync;
        synchronized (object) {
            return (OBJECT)(this.objectList == null || name == null ? null : (DBSObject)this.getObjectMap().get(this.caseSensitive ? name : name.toUpperCase()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheSize() {
        Object object = this.cacheSync;
        synchronized (object) {
            return this.objectList == null ? 0 : this.objectList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheObject(@NotNull OBJECT object) {
        Object object2 = this.cacheSync;
        synchronized (object2) {
            String name;
            if (this.objectList == null) {
                this.objectList = new ArrayList<OBJECT>();
            }
            this.detectCaseSensitivity((DBSObject)object);
            this.objectList.add(object);
            if (this.objectMap != null && this.checkDuplicateName(name = this.getObjectName(object), object)) {
                this.objectMap.put(name, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        Object object2 = this.cacheSync;
        synchronized (object2) {
            if (this.objectList != null) {
                this.detectCaseSensitivity((DBSObject)object);
                this.objectList.remove(object);
                if (this.objectMap != null) {
                    this.objectMap.remove(this.getObjectName(object));
                }
            }
            if (resetFullCache) {
                this.fullCache = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameObject(@NotNull OBJECT object, @NotNull String oldName, @NotNull String newName) {
        Object object2 = this.cacheSync;
        synchronized (object2) {
            if (this.objectMap != null) {
                if (!this.caseSensitive) {
                    oldName = oldName.toUpperCase(Locale.ENGLISH);
                    newName = newName.toUpperCase(Locale.ENGLISH);
                }
                if (this.objectMap.remove(oldName) == object) {
                    this.objectMap.put(newName, object);
                }
            }
        }
    }

    @Nullable
    public <SUB_TYPE> SUB_TYPE getObject(DBRProgressMonitor monitor, OWNER owner, String name, Class<SUB_TYPE> type) throws DBException {
        Object object = this.getObject(monitor, owner, name);
        return type.isInstance(object) ? (SUB_TYPE)type.cast(object) : null;
    }

    public boolean isEmpty() {
        return CommonUtils.isEmpty(this.objectList);
    }

    @Override
    public boolean isFullyCached() {
        return this.fullCache;
    }

    public void setFullCache(boolean fullCache) {
        this.fullCache = fullCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.cacheSync;
        synchronized (object) {
            this.objectList = null;
            this.objectMap = null;
            this.fullCache = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCache(@NotNull List<OBJECT> objects) {
        Object object = this.cacheSync;
        synchronized (object) {
            this.objectList = objects;
            this.objectMap = null;
            this.fullCache = true;
        }
    }

    protected void addCustomObjects(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull List<OBJECT> objectList) throws DBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeCache(List<OBJECT> objects) {
        Object object = this.cacheSync;
        synchronized (object) {
            if (this.objectList != null) {
                objects = new ArrayList<OBJECT>(objects);
                int i = 0;
                while (i < objects.size()) {
                    DBSObject newObject = (DBSObject)objects.get(i);
                    String newObjectName = newObject.getName();
                    int k = 0;
                    while (k < this.objectList.size()) {
                        DBSObject oldObject = (DBSObject)this.objectList.get(k);
                        String oldObjectName = oldObject.getName();
                        if (newObjectName.equals(oldObjectName)) {
                            objects.set(i, oldObject);
                            break;
                        }
                        ++k;
                    }
                    ++i;
                }
            }
        }
        this.setCache(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, OBJECT> getObjectMap() {
        Object object = this.cacheSync;
        synchronized (object) {
            if (this.objectMap == null) {
                this.objectMap = new HashMap<String, OBJECT>();
                if (this.objectList.size() > 0) {
                    this.detectCaseSensitivity((DBSObject)this.objectList.get(0));
                }
                for (DBSObject object2 : this.objectList) {
                    String name = this.getObjectName(object2);
                    if (!this.checkDuplicateName(name, object2)) continue;
                    this.objectMap.put(name, object2);
                }
            }
            return this.objectMap;
        }
    }

    private boolean checkDuplicateName(String name, OBJECT object) {
        if (this.objectMap.containsKey(name)) {
            log.debug("Duplicate object name '" + name + "' in cache " + this.getClass().getSimpleName() + ". Last value: " + DBUtils.getObjectFullName(object, DBPEvaluationContext.DDL));
            return this.isValidDuplicateObject(object);
        }
        return true;
    }

    protected boolean isValidDuplicateObject(OBJECT object) {
        return false;
    }

    protected void detectCaseSensitivity(DBSObject object) {
        DBPDataSource dataSource;
        if (this.caseSensitive && (dataSource = object.getDataSource()) != null && dataSource.getSQLDialect().storesUnquotedCase() == DBPIdentifierCase.MIXED) {
            this.caseSensitive = false;
        }
    }

    protected boolean isValidObject(DBRProgressMonitor monitor, OWNER owner, OBJECT object) throws DBException {
        return true;
    }

    protected void invalidateObjects(DBRProgressMonitor monitor, OWNER owner, Iterator<OBJECT> objectIter) throws DBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildrenOf(DBSObject parent) {
        Object object = this.cacheSync;
        synchronized (object) {
            if (this.objectList == null) {
                return;
            }
            int i = 0;
            while (i < this.objectList.size()) {
                DBSObject object2 = (DBSObject)this.objectList.get(i);
                if (object2.getParentObject() == parent) {
                    this.objectList.remove(object2);
                    if (this.objectMap != null) {
                        this.objectMap.remove(this.getObjectName(object2));
                    }
                    this.fullCache = false;
                    continue;
                }
                ++i;
            }
        }
    }

    @NotNull
    protected String getObjectName(@NotNull OBJECT object) {
        String name = object instanceof DBPUniqueObject ? ((DBPUniqueObject)object).getUniqueName() : object.getName();
        if (name == null) {
            return null;
        }
        if (!this.caseSensitive) {
            return name.toUpperCase();
        }
        return name;
    }

    protected void deepCopyCachedObject(@NotNull Object srcObject, @NotNull Object dstObject) {
        if (srcObject.getClass() != dstObject.getClass()) {
            log.error("Can't make object copy: src class " + srcObject.getClass().getName() + "' != dest class '" + dstObject.getClass().getName() + "'");
            return;
        }
        try {
            Class<?> theClass = srcObject.getClass();
            while (theClass != Object.class) {
                Field[] fields;
                Field[] fieldArray = fields = theClass.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    int modifiers = field.getModifiers();
                    if (!Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers)) {
                        field.setAccessible(true);
                        Object srcValue = field.get(srcObject);
                        Object dstValue = field.get(dstObject);
                        if (DBSObjectCache.class.isAssignableFrom(field.getType())) {
                            if (dstValue != null) {
                                ((DBSObjectCache)dstValue).clearCache();
                            }
                        } else if (Collection.class.isAssignableFrom(field.getType())) {
                            if (Modifier.isTransient(modifiers) && dstValue != null) {
                                ((Collection)dstValue).clear();
                            }
                        } else if (AbstractObjectCache.isPropertyGroupField(field)) {
                            if (dstValue != null && srcValue != null && dstValue.getClass() == srcValue.getClass()) {
                                this.deepCopyCachedObject(srcValue, dstValue);
                            }
                        } else if (!Modifier.isFinal(modifiers)) {
                            field.set(dstObject, srcValue);
                        }
                    }
                    ++n2;
                }
                theClass = theClass.getSuperclass();
            }
        }
        catch (Throwable e) {
            log.error("Error copying object state", e);
        }
    }

    public static boolean isPropertyGroupField(Field field) {
        String getterName = "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
        Method[] methodArray = field.getDeclaringClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method getter = methodArray[n2];
            if (getter.getName().equals(getterName) && AbstractObjectCache.isPropertyGetter(getter) && getter.getAnnotation(PropertyGroup.class) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPropertyGetter(Method method) {
        if (BeanUtils.isGetterName((String)method.getName())) {
            return method.getParameterTypes().length == 0 || method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == DBRProgressMonitor.class;
        }
        return false;
    }

    protected class CacheIterator
    implements Iterator<OBJECT> {
        private final Iterator<OBJECT> listIterator;
        private OBJECT curObject;

        public CacheIterator() {
            this.listIterator = AbstractObjectCache.this.objectList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public OBJECT next() {
            this.curObject = (DBSObject)this.listIterator.next();
            return this.curObject;
        }

        @Override
        public void remove() {
            this.listIterator.remove();
            if (AbstractObjectCache.this.objectMap != null) {
                AbstractObjectCache.this.objectMap.remove(AbstractObjectCache.this.getObjectName(this.curObject));
            }
        }
    }
}

